/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.exception.FoundationRuntimeException;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v390.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v390.logic.MsdrgUtility;
import gov.agency.msdrg.v390.logic.finalprocess.MsdrgFinalMarkingLogic;
import gov.agency.msdrg.v390.logic.initialprocess.MsdrgInitialMarkingLogic;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgMdcRerouteGrouping
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgMdcRerouteGrouping.class);
    private MsdrgInteractionDao dataAccess;

    @Override
    public boolean execute(ProcessingContext context) throws FoundationException {
        MsdrgMaskBuildingConditions condition = (MsdrgMaskBuildingConditions)((Object)context.get(MsdrgChainContext.GROUPING_TYPE));
        MsdrgMatchedDrgFormula matchedFormula = condition == MsdrgMaskBuildingConditions.INITIAL ? (MsdrgMatchedDrgFormula)context.get(MsdrgChainContext.INITIAL_MATCHED_FORMULA) : (MsdrgMatchedDrgFormula)context.get(MsdrgChainContext.FINAL_MATCHED_FORMULA);
        if (matchedFormula == null) {
            throw new FoundationRuntimeException("No matched formula cannot perform reroute grouping");
        }
        if (matchedFormula.getReRouteMdcId() == 0) {
            return true;
        }
        this.dataAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        Map suppliers = (Map)context.get(MsdrgChainContext.AST_SUPPLIER_MAP);
        LinkedList initialMdcs = (LinkedList)context.get(MsdrgChainContext.INITIAL_MDC);
        LinkedList finalMdcs = (LinkedList)context.get(MsdrgChainContext.FINAL_MDC);
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            initialMdcs.add(matchedFormula.getReRouteMdcId());
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            finalMdcs.add(matchedFormula.getReRouteMdcId());
        }
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        RuntimeOptions runtimeOptions = (RuntimeOptions)context.get(MsdrgChainContext.RUNTIME_OPTIONS);
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.rerouteGrouping(processingData, condition, matchedFormula, suppliers, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt());
        if (evalContainer == null) {
            throw new FoundationException("Formula evaluation failed.");
        }
        MsdrgMatchedDrgFormula newMatchedFormula = evalContainer.getMatchedDrgFormula();
        MsdrgSeverity severity = evalContainer.getSeverity();
        if (newMatchedFormula.getReRouteMdcId() != 0) {
            evalContainer = this.rerouteGrouping(processingData = this.rerouteMarking(processingData, runtimeOptions, condition, newMatchedFormula, newMatchedFormula.getReRouteMdcId()), condition, newMatchedFormula, suppliers, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt());
            if (evalContainer != null) {
                newMatchedFormula = evalContainer.getMatchedDrgFormula();
            } else {
                throw new FoundationException("Formula evaluation failed.");
            }
        }
        if (matchedFormula.getFormula() != null && matchedFormula.getFormula().contains("grc 5")) {
            MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS, this.dataAccess);
            MsdrgUtility.resetSeverity(processingData.getSdxCodes(), condition.equals((Object)MsdrgMaskBuildingConditions.INITIAL));
            context.put(MsdrgChainContext.PROCESSING_DATA, processingData.toBuilder().withFinalResult(grouperResult).withInitialResult(grouperResult).build());
            return false;
        }
        processingData = this.rerouteMarking(processingData, runtimeOptions, condition, newMatchedFormula, matchedFormula.getReRouteMdcId());
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            context.put(MsdrgChainContext.INITIAL_MATCHED_FORMULA, newMatchedFormula);
            processingData = processingData.toBuilder().withInitialSeverity(severity).build();
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            context.put(MsdrgChainContext.FINAL_MATCHED_FORMULA, newMatchedFormula);
            processingData = processingData.toBuilder().withFinalSeverity(severity).build();
        }
        context.put(MsdrgChainContext.INITIAL_MDC, initialMdcs);
        context.put(MsdrgChainContext.FINAL_MDC, finalMdcs);
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData);
        return true;
    }

    private ProcessingData rerouteMarking(ProcessingData processingData, RuntimeOptions runtimeOptions, MsdrgMaskBuildingConditions condition, MsdrgMatchedDrgFormula matchedFormula, int mdc) {
        ProcessingData data = ProcessingData.builder().build();
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            if (!matchedFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgInitialMarkingLogic initialMarkingLogic = new MsdrgInitialMarkingLogic();
                data = initialMarkingLogic.initialMarking(matchedFormula, processingData, mdc);
            }
        } else if (condition == MsdrgMaskBuildingConditions.FINAL && !matchedFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
            MsdrgFinalMarkingLogic finalMarkingLogic = new MsdrgFinalMarkingLogic();
            data = finalMarkingLogic.finalMarking(matchedFormula, processingData, mdc);
        }
        return data;
    }

    private MsdrgFormulaEvaluation.EvalContainer rerouteGrouping(ProcessingData processingData, MsdrgMaskBuildingConditions condition, MsdrgMatchedDrgFormula matchedFormula, Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers, MsdrgAffectDrgOptionFlag computeAffectDrg, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        int mdc = matchedFormula.getReRouteMdcId();
        logger.debug("Reroute logic");
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        logger.debug("Try grouping with mdc: {}", (Object)mdc);
        MsdrgFormulaEvaluation formulaEvaluation = new MsdrgFormulaEvaluation(this.dataAccess);
        formulaEvaluation.setSuppliers(suppliers);
        return formulaEvaluation.evaluateFormulas(processingData.getSdxCodes(), condition, mdc, mask, computeAffectDrg, hospitalStatus);
    }
}

