/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v390.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v390.logic.MsdrgUtility;
import gov.agency.msdrg.v390.logic.finalprocess.MsdrgFinalMarkingLogic;
import gov.agency.msdrg.v390.logic.initialprocess.MsdrgInitialMarkingLogic;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgPdxMdcGrouping
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgPdxMdcGrouping.class);
    private MsdrgInteractionDao dataAccess;

    @Override
    public boolean execute(ProcessingContext context) throws FoundationException {
        this.dataAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        MsdrgMaskBuildingConditions condition = (MsdrgMaskBuildingConditions)((Object)context.get(MsdrgChainContext.GROUPING_TYPE));
        Map suppliers = (Map)context.get(MsdrgChainContext.AST_SUPPLIER_MAP);
        LinkedList initialMdcs = (LinkedList)context.get(MsdrgChainContext.INITIAL_MDC);
        LinkedList finalMdcs = (LinkedList)context.get(MsdrgChainContext.FINAL_MDC);
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        MsdrgMatchedDrgFormula matchedFormula = null;
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            matchedFormula = (MsdrgMatchedDrgFormula)context.get(MsdrgChainContext.INITIAL_MATCHED_FORMULA);
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            matchedFormula = (MsdrgMatchedDrgFormula)context.get(MsdrgChainContext.FINAL_MATCHED_FORMULA);
        }
        if (matchedFormula != null && matchedFormula.getDrg() != 0) {
            return true;
        }
        RuntimeOptions runtimeOptions = (RuntimeOptions)context.get(MsdrgChainContext.RUNTIME_OPTIONS);
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.pdxMdcGrouping(processingData, condition, suppliers, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt(), processingData.getPrincipalDx().getMdc());
        if (evalContainer == null) {
            throw new FoundationException("Could not evaluate formula");
        }
        matchedFormula = evalContainer.getMatchedDrgFormula();
        if (matchedFormula.getFormula() != null && matchedFormula.getFormula().contains("grc 5")) {
            MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS, this.dataAccess);
            MsdrgUtility.resetSeverity(processingData.getSdxCodes(), condition.equals((Object)MsdrgMaskBuildingConditions.INITIAL));
            context.put(MsdrgChainContext.PROCESSING_DATA, processingData.toBuilder().withInitialResult(grouperResult).withFinalResult(grouperResult).build());
            return false;
        }
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            context.put(MsdrgChainContext.INITIAL_MATCHED_FORMULA, matchedFormula);
            initialMdcs.add(processingData.getPrincipalDx().getMdc());
            context.put(MsdrgChainContext.INITIAL_MDC, initialMdcs);
            if (!matchedFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgInitialMarkingLogic initialMarkingLogic = new MsdrgInitialMarkingLogic();
                processingData = initialMarkingLogic.initialMarking(matchedFormula, processingData, processingData.getPrincipalDx().getMdc());
            }
            processingData = processingData.toBuilder().withInitialSeverity(evalContainer.getSeverity()).build();
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            context.put(MsdrgChainContext.FINAL_MATCHED_FORMULA, matchedFormula);
            finalMdcs.add(processingData.getPrincipalDx().getMdc());
            context.put(MsdrgChainContext.FINAL_MDC, finalMdcs);
            if (!matchedFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgFinalMarkingLogic finalMarkingLogic = new MsdrgFinalMarkingLogic();
                processingData = finalMarkingLogic.finalMarking(matchedFormula, processingData, processingData.getPrincipalDx().getMdc());
            }
            processingData = processingData.toBuilder().withFinalSeverity(evalContainer.getSeverity()).build();
        }
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData);
        return true;
    }

    private MsdrgFormulaEvaluation.EvalContainer pdxMdcGrouping(ProcessingData processingData, MsdrgMaskBuildingConditions condition, Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers, MsdrgAffectDrgOptionFlag computeAffectDrg, MsdrgHospitalStatusOptionFlag hospitalStatus, int mdc) {
        logger.debug("Reroute and premdc didn't find results");
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        logger.debug("Try grouping with mdc: {}", (Object)mdc);
        MsdrgFormulaEvaluation formulaEvaluation = new MsdrgFormulaEvaluation(this.dataAccess);
        formulaEvaluation.setSuppliers(suppliers);
        return formulaEvaluation.evaluateFormulas(processingData.getSdxCodes(), condition, mdc, mask, computeAffectDrg, hospitalStatus);
    }
}

