/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.initialprocess;

import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.MsdrgGrouperResultReport;
import java.util.LinkedList;

public class MsdrgInitialDrgResults
implements Link {
    private static final int UNGROUPABLE = 999;

    @Override
    public boolean execute(ProcessingContext context) {
        MsdrgGrouperResult result;
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        MsdrgMatchedDrgFormula matchedFormula = (MsdrgMatchedDrgFormula)context.get(MsdrgChainContext.INITIAL_MATCHED_FORMULA);
        LinkedList allMdcStops = (LinkedList)context.get(MsdrgChainContext.INITIAL_MDC);
        MsdrgInteractionDao dataAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        MsdrgGrouperResultReport report = new MsdrgGrouperResultReport();
        if (matchedFormula.getDrg() == 999) {
            result = report.createGrouperResult(0, matchedFormula, processingData.getInitialSeverity(), dataAccess);
        } else {
            int mdc = processingData.getPrincipalDx().getMdc();
            if ((Integer)allMdcStops.getLast() == 29) {
                mdc = allMdcStops.contains(24) ? 24 : (allMdcStops.contains(25) ? 25 : (Integer)allMdcStops.get(allMdcStops.size() - 2));
            } else if ((Integer)allMdcStops.getLast() != 0) {
                mdc = (Integer)allMdcStops.getLast();
            }
            result = report.createGrouperResult(mdc, matchedFormula, processingData.getInitialSeverity(), dataAccess);
        }
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData.toBuilder().withInitialResult(result).build());
        return true;
    }
}

