/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.preprocess;

import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgExclusions
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgExclusions.class);

    @Override
    public boolean execute(ProcessingContext context) {
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        String pdx = processingData.getPrincipalDx().getValue();
        logger.debug("Begin processing exclusions");
        List<Object> exclusions = new ArrayList();
        try {
            exclusions = this.processExclusions(pdx, sdxCodes, (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS));
        }
        catch (IOException | SQLException exception) {
            exception.printStackTrace();
        }
        if (processingData.getDischargeStatus() == MsdrgDischargeStatus.DIED) {
            logger.debug("Discharge status of death so process death exclusions");
            exclusions = this.deathExclusions(sdxCodes);
            logger.debug("Death exclusions processed");
        }
        logger.debug("Exclusions processed");
        if (!exclusions.isEmpty()) {
            context.put(MsdrgChainContext.PROCESSING_DATA, processingData.toBuilder().withSdxCodes(exclusions).build());
        }
        return true;
    }

    private List<MsdrgDiagnosisCode> processExclusions(String pdx, List<MsdrgDiagnosisCode> sdxCodes, MsdrgInteractionDao dbAccess) throws IOException, SQLException {
        List<String> exclusionCodes = dbAccess.getExclusions(pdx);
        logger.debug("Exclusions retrieved for code: {}", (Object)pdx);
        for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
            if (!exclusionCodes.contains(sdxCode.getValue())) continue;
            sdxCode.setExcluded(true);
        }
        return sdxCodes;
    }

    private List<MsdrgDiagnosisCode> deathExclusions(List<MsdrgDiagnosisCode> sdxCodes) {
        for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
            if (sdxCode.getAttributes() == null || !sdxCode.hasAttribute("mccalive")) continue;
            sdxCode.setExcluded(true);
        }
        return sdxCodes;
    }
}

