/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.preprocess;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgCodeType;
import gov.agency.msdrg.model.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.enumeration.MsdrgSex;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.DiagnosisAttributeProcessor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdxAttributeProcessor
extends DiagnosisAttributeProcessor
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(PdxAttributeProcessor.class);

    @Override
    public boolean execute(ProcessingContext context) {
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        this.dataAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        logger.debug("Begin processing of attributes");
        MsdrgDiagnosisCode admitDx = processingData.getAdmitDx();
        MsdrgDiagnosisCode pdx = processingData.getPrincipalDx();
        if (!pdx.getValue().isEmpty()) {
            Set<Attribute> attributes = this.getDiagnosisAttributes(pdx, MsdrgCodeType.PDX);
            pdx.setAttributes(attributes);
            Set<Attribute> dxCatAttributes = this.getDiagnosisDxCatAttributes(pdx, MsdrgCodeType.PDX);
            pdx.setDxCatAttributes(dxCatAttributes);
            Set<Attribute> dxHacAttributes = this.getDiagnosisHacAttributes(pdx, MsdrgCodeType.PDX);
            pdx.setHacAttributes(dxHacAttributes);
            if (!dxHacAttributes.isEmpty()) {
                for (Attribute attr : dxHacAttributes) {
                    if (!attr.getListName().endsWith("hac11_pdx")) continue;
                    MsdrgHac hac = new MsdrgHac();
                    hac.setHacStatus(MsdrgHacUsage.NOT_ON_HAC_LIST);
                    hac.setHacList("hac11_pdx");
                    hac.setHacNumber(11);
                    hac.setDescription(this.dataAccess.getHacDescription(11));
                    pdx.setHacs(Collections.singletonList(hac));
                }
            }
            pdx.setValidCode(this.dataAccess.isCodeValid(pdx.getValue()));
            try {
                boolean onGenderList = this.dataAccess.isCodeOnGenderList(pdx.getValue());
                if (onGenderList) {
                    Integer mdc = this.dataAccess.getMdcOfGenderCode(pdx.getValue(), processingData.getSex().getIntValue());
                    if (mdc == null) {
                        pdx.setSexConflict(true);
                        pdx.setMdc(this.dataAccess.getMdcOfGenderCode(pdx.getValue(), MsdrgSex.FEMALE.getIntValue()));
                    } else {
                        pdx.setMdc(mdc);
                    }
                } else {
                    pdx.setMdc(this.getDiagnosisMdc(pdx));
                }
                pdx.setSeverity(this.getDiagnosisSeverity(pdx));
            }
            catch (IOException | SQLException exception) {
                exception.printStackTrace();
            }
        }
        admitDx.setValidCode(this.dataAccess.isCodeValid(admitDx.getValue()));
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData.toBuilder().withAdmitDx(admitDx).withPdx(pdx).build());
        logger.debug("Attributes processed");
        return true;
    }
}

