/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.preprocess;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgOperandType;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.model.transfer.MsdrgClaim;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.ast.BilateralAstNode;
import gov.agency.msdrg.v390.logic.ast.DrugEludingStentAstNode;
import gov.agency.msdrg.v390.logic.ast.NonDrugEludingStentAstNode;
import gov.agency.msdrg.v390.logic.ast.VesselAstNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureAttributeProcessor
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(ProcedureAttributeProcessor.class);
    private MsdrgInteractionDao dbAccess;

    @Override
    public boolean execute(ProcessingContext context) {
        MsdrgClaim claim = (MsdrgClaim)context.get(MsdrgChainContext.CLAIM);
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        this.dbAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        logger.debug("Begin processing of attributes");
        ArrayList<MsdrgProcedureCode> processingProcCodes = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
        for (MsdrgProcedureCode msdrgProcedureCode : processingProcCodes) {
            msdrgProcedureCode.setAttributes(this.getProcedureAttributes(msdrgProcedureCode));
            Optional<Attribute> maybeAttribute = this.addOperatingRoomProcedure(msdrgProcedureCode);
            if (maybeAttribute.isPresent()) {
                Attribute attribute = maybeAttribute.get();
                attribute.setMdcSuppression(msdrgProcedureCode.getMdcSuppression());
                msdrgProcedureCode.getAttributes().add(attribute);
            }
            msdrgProcedureCode.setValidCode(!msdrgProcedureCode.getAttributes().isEmpty());
        }
        ArrayList<MsdrgProcedureCode> processingDataClusters = new ArrayList<MsdrgProcedureCode>(processingData.getClusters());
        for (MsdrgProcedureCode clusterCode : processingDataClusters) {
            clusterCode.setAttributes(this.getClusterAttributes(clusterCode));
            Optional<Attribute> maybeAttribute = this.addOperatingRoomProcedure(clusterCode);
            maybeAttribute.ifPresent(clusterCode.getAttributes()::add);
        }
        Map map = (Map)context.get(MsdrgChainContext.AST_SUPPLIER_MAP);
        BilateralAstNode.BilateralNodeSupplier nodeSupplier = (BilateralAstNode.BilateralNodeSupplier)map.get(MsdrgSourceLogicLists.BILATERAL.getValue());
        nodeSupplier.setOrderedCodes(processingProcCodes);
        VesselAstNode.VesselNodeSupplier vesselNodeSupplier = (VesselAstNode.VesselNodeSupplier)map.get(MsdrgSourceLogicLists.FOUR_VESSELS.getValue());
        vesselNodeSupplier.setOrderedCodes(processingProcCodes);
        DrugEludingStentAstNode.DrugEludingNodeSupplier drugEludingNodeSupplier = (DrugEludingStentAstNode.DrugEludingNodeSupplier)map.get(MsdrgSourceLogicLists.FOUR_DRUG_ELUTING_STENTS.getValue());
        drugEludingNodeSupplier.setOrderedCodes(processingProcCodes);
        NonDrugEludingStentAstNode.NonDrugEludingNodeSupplier nonDrugEludingNodeSupplier = (NonDrugEludingStentAstNode.NonDrugEludingNodeSupplier)map.get(MsdrgSourceLogicLists.FOUR_NON_DRUG_ELUTING_STENTS.getValue());
        nonDrugEludingNodeSupplier.setOrderedCodes(processingProcCodes);
        ProcessingData updatedProcessingData = processingData.toBuilder().withClusters(processingDataClusters).withProcedures(processingProcCodes).build();
        context.put(MsdrgChainContext.PROCESSING_DATA, updatedProcessingData);
        return true;
    }

    private Set<Attribute> getProcedureAttributes(MsdrgProcedureCode procCode) {
        Set<Attribute> attributes = this.dbAccess.getAttributesForCode(procCode.getValue(), Arrays.asList(MsdrgOperandType.PROC_LIST.getOperandTypeInt(), MsdrgOperandType.PROC_HAC.getOperandTypeInt()), "NONE");
        attributes.forEach(attribute -> attribute.setMdcSuppression(procCode.getMdcSuppression()));
        return attributes;
    }

    private Set<Attribute> getClusterAttributes(MsdrgProcedureCode clusterCode) {
        return this.dbAccess.getAttributesForCode(clusterCode.getValue(), Arrays.asList(MsdrgOperandType.PROC_LIST.getOperandTypeInt(), MsdrgOperandType.PROC_HAC.getOperandTypeInt()), "NONE");
    }

    private Optional<Attribute> addOperatingRoomProcedure(MsdrgProcedureCode code) {
        Optional<Attribute> attr = Optional.empty();
        if (code.hasAttribute(new Attribute("d477")) || code.hasAttribute(new Attribute("d468"))) {
            attr = Optional.of(new Attribute(MsdrgAttributePrefix.NONE, false, MsdrgSourceLogicLists.ORPROC.getValue()));
        }
        return attr;
    }
}

