/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.preprocess;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgCodeType;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.DiagnosisAttributeProcessor;
import gov.agency.msdrg.v390.logic.ast.SigTraumaAstNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdxAttributeProcessor
extends DiagnosisAttributeProcessor
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(SdxAttributeProcessor.class);

    @Override
    public boolean execute(ProcessingContext context) {
        logger.debug("Begin processing of attributes");
        this.dataAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        RuntimeOptions runtimeOption = (RuntimeOptions)context.get(MsdrgChainContext.RUNTIME_OPTIONS);
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            dxCode.setValidCode(this.dataAccess.isCodeValid(dxCode.getValue()));
        }
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            try {
                dxCode.setSeverity(this.getDiagnosisSeverity(dxCode));
            }
            catch (IOException | SQLException exception) {
                exception.printStackTrace();
            }
            Set<Attribute> attributes = this.getDiagnosisAttributes(dxCode, MsdrgCodeType.SDX);
            dxCode.setAttributes(attributes);
            Set<Attribute> dxCatAttributes = this.getDiagnosisDxCatAttributes(dxCode, MsdrgCodeType.SDX);
            dxCode.setDxCatAttributes(dxCatAttributes);
            Set<Attribute> dxHacAttributes = this.getDiagnosisHacAttributes(dxCode, MsdrgCodeType.SDX);
            dxCode.setHacAttributes(dxHacAttributes);
            if (!dxHacAttributes.isEmpty()) {
                for (Attribute attr : dxHacAttributes) {
                    if (!attr.getListName().startsWith("HAC")) continue;
                    dxCode.setHacs(this.getDiagnosisHac(dxCode));
                }
            }
            if (dxHacAttributes.contains(new Attribute(MsdrgAttributePrefix.SDX, "hac06_show"))) {
                dxCode.setOnShowList(true);
            }
            Optional<Integer> maybeClinSig = this.dataAccess.getClinicalSignificanceOfCode(dxCode.getValue());
            maybeClinSig.ifPresent(dxCode::setClinicalSignificanceRank);
        }
        if (runtimeOption.getMarkingLogicTieBreaker() == MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE) {
            sdxCodes.sort((o1, o2) -> {
                if (!o1.isValidCode()) {
                    return 1;
                }
                if (!o2.isValidCode()) {
                    return -1;
                }
                return o1.getClinicalSignificanceRank().compareTo(o2.getClinicalSignificanceRank());
            });
        }
        Map suppliers = (Map)context.get(MsdrgChainContext.AST_SUPPLIER_MAP);
        SigTraumaAstNode.SigTraumaNodeSupplier nodeSupplier = (SigTraumaAstNode.SigTraumaNodeSupplier)suppliers.get(MsdrgSourceLogicLists.MULTST.getValue());
        nodeSupplier.setOrderedCodes(processingData.getPrincipalDx(), sdxCodes);
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData.toBuilder().withSdxCodes(sdxCodes).build());
        return true;
    }
}

