/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.model.GfcPoa;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgCode;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgGrouperFlags;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.MsdrgOption;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.MsdrgRuntimeOption;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgSex;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.model.transfer.MsdrgClaim;
import gov.agency.msdrg.model.transfer.MsdrgInputData;
import gov.agency.msdrg.model.transfer.MsdrgInputDxCode;
import gov.agency.msdrg.model.transfer.MsdrgInputPrCode;
import gov.agency.msdrg.model.transfer.MsdrgOutput;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.blob.DataBlob;
import gov.agency.msdrg.v391.access.dao.FormulaAccess;
import gov.agency.msdrg.v391.access.pojo.MsdrgDrgFormulas;
import gov.agency.msdrg.v391.chain.GrouperChain;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.FormulaEvaluator;
import gov.agency.msdrg.v391.logic.MsdrgCodeFlagsProcessor;
import gov.agency.msdrg.v391.logic.MsdrgGrouperFlagsResult;
import gov.agency.msdrg.v391.logic.RuntimeDataValidation;
import gov.agency.msdrg.v391.logic.ast.BilateralAstNode;
import gov.agency.msdrg.v391.logic.ast.DrugEludingStentAstNode;
import gov.agency.msdrg.v391.logic.ast.NonDrugEludingStentAstNode;
import gov.agency.msdrg.v391.logic.ast.SigTraumaAstNode;
import gov.agency.msdrg.v391.logic.ast.VesselAstNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgComponent
implements Processable<MsdrgClaim, MsdrgOption, MsdrgRuntimeOption> {
    public static final String NULL_CODE_VALUE = String.valueOf(null);
    public static final GfcPoa NULL_POA = GfcPoa.BLANK;
    private static final Logger logger = LoggerFactory.getLogger(MsdrgComponent.class);
    private final Map<String, NodeSupplier<DrgLexerToken, Attribute>> supplierMap = new HashMap<String, NodeSupplier<DrgLexerToken, Attribute>>();
    private RuntimeOptions options;
    private Link grouperChain;

    public MsdrgComponent(MsdrgRuntimeOption options) {
        logger.debug("Initializing component constructor");
        this.options = (RuntimeOptions)options.get((Object)MsdrgOption.RUNTIME_OPTION_FLAGS);
        this.initialize();
    }

    protected void initialize() {
        this.grouperChain = GrouperChain.createChain(DataBlob.getInstance());
        this.supplierMap.put(MsdrgSourceLogicLists.BILATERAL.getValue(), new BilateralAstNode.BilateralNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.FOUR_VESSELS.getValue(), new VesselAstNode.VesselNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.MULTST.getValue(), new SigTraumaAstNode.SigTraumaNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.FOUR_DRUG_ELUTING_STENTS.getValue(), new DrugEludingStentAstNode.DrugEludingNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.FOUR_NON_DRUG_ELUTING_STENTS.getValue(), new NonDrugEludingStentAstNode.NonDrugEludingNodeSupplier());
        FormulaAccess formulaDao = new FormulaAccess(DataBlob.getInstance());
        for (int mdc = 0; mdc < 30; ++mdc) {
            List<MsdrgDrgFormulas> allFormulaRowsByMdc = formulaDao.getAllFormulaRowsByMdc(mdc);
            if (allFormulaRowsByMdc == null) continue;
            for (MsdrgDrgFormulas msdrgDrgFormulas : allFormulaRowsByMdc) {
                FormulaEvaluator.lexFormula(msdrgDrgFormulas.getFormula());
            }
        }
    }

    @Override
    public void process(MsdrgClaim claim) throws FoundationException {
        logger.debug("Begin processing claim");
        RuntimeOptions runtime = RuntimeDataValidation.execute(this.options);
        ProcessingData processingData = this.createProcessingData(claim);
        ArrayList<MsdrgProcedureCode> originalProcedureOrder = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
        ArrayList<MsdrgDiagnosisCode> originalDiagnosisOrder = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        if (runtime.getMarkingLogicTieBreaker() == MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE) {
            ArrayList<MsdrgProcedureCode> procCodes = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
            procCodes.sort(Comparator.comparing(MsdrgCode::getValue));
            processingData = processingData.toBuilder().withProcedures(procCodes).build();
        }
        ProcessingContext context = ProcessingContext.builder().withProcessingData(processingData).withSupplierMap(this.supplierMap).withRuntime(runtime).build();
        Link.LinkResult linkResult = this.grouperChain.execute(context);
        ProcessingData processedData = (context = linkResult.getContext()).getProcessingData();
        if (processedData.getSdxCodes() != null) {
            processedData = processedData.toBuilder().withSdxCodes(originalDiagnosisOrder).build();
        }
        if (processedData.getProcedureCodes() != null) {
            processedData = processedData.toBuilder().withProcedures(originalProcedureOrder).build();
        }
        MsdrgOutput output = this.createOutput(processedData, context);
        claim.setOutput(output);
    }

    private MsdrgOutput createOutput(ProcessingData processedData, ProcessingContext context) {
        RuntimeOptions runtimeOptions = context.getRuntime();
        MsdrgMatchedDrgFormula initialMatchedFormula = context.getInitialMatchedFormula().orElse(new MsdrgMatchedDrgFormula());
        MsdrgMatchedDrgFormula finalMatchedFormula = context.getFinalMatchedFormula().orElse(new MsdrgMatchedDrgFormula());
        MsdrgGrouperFlags grouperFlags = MsdrgGrouperFlagsResult.createGrouperFlags(processedData, runtimeOptions.getPoaReportingExempt(), runtimeOptions.getComputeAffectDrg(), initialMatchedFormula, finalMatchedFormula);
        MsdrgCodeFlagsProcessor.TempFlagsContainer tempFlagsContainer = MsdrgCodeFlagsProcessor.processCodeFlags(processedData, context);
        return MsdrgOutput.builder().withProcOutput(tempFlagsContainer.getProcFlagMap()).withSdxOutput(tempFlagsContainer.getDxFlagMap()).withFinalGrouperResult(processedData.getFinalResult()).withInitialGrouperResult(processedData.getInitialResult()).withPdxOutput(tempFlagsContainer.getPdxFlagMap()).withGrouperFlags(grouperFlags).build();
    }

    private ProcessingData createProcessingData(MsdrgClaim claim) {
        MsdrgInputData input = claim.getInput();
        MsdrgInputDxCode pdx = input.getPrincipalDiagnosisCode().orElse(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA));
        MsdrgInputDxCode admit = input.getAdmissionDiagnosisCode().orElse(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA));
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>();
        for (MsdrgInputDxCode secondaryDiagnosisCode : input.getSecondaryDiagnosisCodes()) {
            if (secondaryDiagnosisCode == null) {
                sdxCodes.add(new MsdrgDiagnosisCode(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA)));
                continue;
            }
            sdxCodes.add(new MsdrgDiagnosisCode(secondaryDiagnosisCode));
        }
        ProcessingData.ProcessingDataBuilder processingDataBuilder = ProcessingData.builder().withAdmitDx(new MsdrgDiagnosisCode(admit)).withPdx(new MsdrgDiagnosisCode(pdx)).withSdxCodes(sdxCodes).withDischargeStatus(input.getDischargeStatus().orElse(MsdrgDischargeStatus.NONE)).withSex(input.getSex().orElse(MsdrgSex.UNKNOWN));
        if (!input.getProcedureCodes().isEmpty()) {
            ArrayList<MsdrgProcedureCode> procedureCodes = new ArrayList<MsdrgProcedureCode>();
            for (MsdrgInputPrCode procedureCode : input.getProcedureCodes()) {
                if (procedureCode == null) {
                    procedureCodes.add(new MsdrgProcedureCode(new MsdrgInputPrCode(NULL_CODE_VALUE)));
                    continue;
                }
                procedureCodes.add(new MsdrgProcedureCode(procedureCode));
            }
            MsdrgProcedureCode code = (MsdrgProcedureCode)procedureCodes.get(0);
            if (code != null) {
                code.setFirstPosition(true);
            }
            processingDataBuilder.withPrincipalProcedure(code).withProcedures(procedureCodes);
        }
        return processingDataBuilder.build();
    }

    @Override
    public void reconfigure(MsdrgRuntimeOption option) {
        this.options = (RuntimeOptions)option.get((Object)MsdrgOption.RUNTIME_OPTION_FLAGS);
    }

    public RuntimeOptions getOptions() {
        return this.options;
    }

    @Override
    public void close() {
    }
}

