/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.access.blob;

import gov.agency.msdrg.Data;
import gov.agency.msdrg.model.ClusterChoices;
import gov.agency.msdrg.v391.access.blob.DataAccess;
import gov.agency.msdrg.v391.access.blob.dto.ClusterParts;
import gov.agency.msdrg.v391.access.blob.dto.HacFormula;
import gov.agency.msdrg.v391.access.pojo.MsdrgDrgFormulas;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class DataBlob
implements DataAccess {
    private static final DataBlob instance = new DataBlob();
    private Map<String, Data.Diagnosis> diagnosisAll = new HashMap<String, Data.Diagnosis>();
    private Map<Integer, Data.ExclusionGroup> exclusionGroups = new HashMap<Integer, Data.ExclusionGroup>();
    private Map<String, Data.PdxExclusionGroup> exclusionIds = new HashMap<String, Data.PdxExclusionGroup>();
    private Map<String, Data.ClusterData> clusterInformation = new HashMap<String, Data.ClusterData>();
    private Map<String, Data.CodeGenderMdc> genderMdcs = new HashMap<String, Data.CodeGenderMdc>();
    private Map<Integer, List<MsdrgDrgFormulas>> drgFormulas = new HashMap<Integer, List<MsdrgDrgFormulas>>();
    private Map<String, Data.HacInfo> hacOperands = new HashMap<String, Data.HacInfo>();
    private Map<Integer, List<HacFormula>> hacFormulas = new HashMap<Integer, List<HacFormula>>();
    private Map<String, Data.Procedure> procedureAttributes = new HashMap<String, Data.Procedure>();
    private Map<String, Data.CodeToClusterInfo> clusterIds = new HashMap<String, Data.CodeToClusterInfo>();
    private Map<Integer, Data.DxPattern> dxPatterns = new HashMap<Integer, Data.DxPattern>();
    private Map<Integer, Data.PrPattern> prPatterns = new HashMap<Integer, Data.PrPattern>();
    private Map<Integer, String> baseDrgDescriptions = new HashMap<Integer, String>();
    private Map<Integer, String> drgDescriptions = new HashMap<Integer, String>();
    private Map<Integer, String> mdcDescriptions = new HashMap<Integer, String>();
    private Map<Integer, String> hacDescriptions = new HashMap<Integer, String>();

    public static DataBlob getInstance() {
        return instance;
    }

    private DataBlob() {
        try {
            InputStream inputStream = DataBlob.class.getResourceAsStream("/runtime_buffers/msdrg_391.bin");
            Data.Root rootData = Data.Root.parseFrom(inputStream);
            this.loadBuffers(rootData);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    private void loadBuffers(Data.Root rootData) throws IOException {
        this.diagnosisAll = this.loadDxData(rootData);
        this.procedureAttributes = this.loadSgData(rootData);
        this.exclusionIds = this.loadExclPdxData(rootData);
        this.exclusionGroups = this.loadExclGroupData(rootData);
        this.clusterInformation = this.loadClusterData(rootData);
        this.clusterIds = this.loadClusterIdData(rootData);
        this.genderMdcs = this.loadGenderMdcData(rootData);
        this.drgFormulas = this.loadDrgFormulaData(rootData);
        this.hacOperands = this.loadHacOperandData(rootData);
        this.hacFormulas = this.loadHacFormulaData(rootData);
        this.dxPatterns = this.loadDxPatterns(rootData);
        this.prPatterns = this.loadPrPatterns(rootData);
        this.baseDrgDescriptions = this.loadDescriptions(rootData, Data.Root::getBaseDrgDescriptions);
        this.drgDescriptions = this.loadDescriptions(rootData, Data.Root::getDrgDescriptions);
        this.mdcDescriptions = this.loadDescriptions(rootData, Data.Root::getMdcDescription);
        this.hacDescriptions = this.loadDescriptions(rootData, Data.Root::getHacDescription);
    }

    private Map<Integer, String> loadDescriptions(Data.Root rootData, Function<Data.Root, Data.Description> fetchFunction) {
        return fetchFunction.apply(rootData).getDescriptionsMap();
    }

    private Map<Integer, Data.DxPattern> loadDxPatterns(Data.Root rootData) {
        Data.DxPatterns patterns = rootData.getDxPatterns();
        return patterns.getDxPatternsMap();
    }

    private Map<Integer, Data.PrPattern> loadPrPatterns(Data.Root rootData) {
        Data.PrPatterns patterns = rootData.getPrPatterns();
        return patterns.getDxPatternsMap();
    }

    private Map<String, Data.Diagnosis> loadDxData(Data.Root rootData) {
        Data.DiagnosisRoot diagnosisRoot = rootData.getDiagnoses();
        return diagnosisRoot.getDxMapMap();
    }

    private Map<String, Data.Procedure> loadSgData(Data.Root rootData) {
        Data.ProcedureRoot procedureRoot = rootData.getProcedures();
        return procedureRoot.getCodesMap();
    }

    private Map<String, Data.PdxExclusionGroup> loadExclPdxData(Data.Root rootData) {
        Data.PdxExclusionGroupsRoot pdxExclusionGroups = rootData.getPdxExclusionGroups();
        return pdxExclusionGroups.getPdxExclusionGroupsMap();
    }

    private Map<Integer, Data.ExclusionGroup> loadExclGroupData(Data.Root rootData) {
        Data.ExclusionGroupsRoot exclusionGroupsRoot = rootData.getExclusionGroups();
        return exclusionGroupsRoot.getExclusionGroupsMap();
    }

    private Map<String, Data.ClusterData> loadClusterData(Data.Root rootData) {
        Data.ClustersRoot clusters = rootData.getClusters();
        return clusters.getClustersMap();
    }

    private Map<String, Data.CodeToClusterInfo> loadClusterIdData(Data.Root rootData) {
        Data.CodeToClusterIdRoot codeAttributesRoot = rootData.getCodeToClusterIds();
        return codeAttributesRoot.getCodeToClusterIdsMap();
    }

    private Map<String, Data.CodeGenderMdc> loadGenderMdcData(Data.Root rootData) {
        Data.CodeGenderMdcsRoot codeGenderMdcs = rootData.getCodeGenderMdcs();
        return codeGenderMdcs.getCodeGenderMdcsMap();
    }

    private Map<Integer, List<MsdrgDrgFormulas>> loadDrgFormulaData(Data.Root rootData) {
        HashMap<Integer, List<MsdrgDrgFormulas>> drgFormulas = new HashMap<Integer, List<MsdrgDrgFormulas>>();
        Data.FormulaListsRoot formulaLists = rootData.getFormulaLists();
        for (Map.Entry<Integer, Data.FormulaList> entry : formulaLists.getFormulaListsMap().entrySet()) {
            int drgKey = entry.getKey();
            ArrayList<MsdrgDrgFormulas> formulas = new ArrayList<MsdrgDrgFormulas>();
            for (Data.FormulaItem incomingFormula : entry.getValue().getFormulaItemsList()) {
                MsdrgDrgFormulas formula = new MsdrgDrgFormulas();
                formula.setFormula(incomingFormula.getFormula());
                formula.setDrg(incomingFormula.getDrg());
                formula.setBaseDrg(incomingFormula.getBaseDrg());
                formula.setMdc(incomingFormula.getMdc());
                formula.setFormulaCollectionId(incomingFormula.getFormulaCollectionId());
                formula.setRank(incomingFormula.getRank());
                formula.setDrgSeverity(incomingFormula.getDrgSeverity());
                formula.setReRouteMdcId(incomingFormula.getReRouteMdcId());
                formula.setSurgical(incomingFormula.getSurgical());
                formula.setSeveritySuppressionOperand(new HashSet<String>(incomingFormula.getSeveritySuppressionOperandList()));
                formulas.add(formula);
            }
            drgFormulas.put(drgKey, formulas);
        }
        return drgFormulas;
    }

    private Map<String, Data.HacInfo> loadHacOperandData(Data.Root rootData) {
        Data.HacInfoRoot hacInfos = rootData.getHacInformation();
        return hacInfos.getHacInfosMap();
    }

    private Map<Integer, List<HacFormula>> loadHacFormulaData(Data.Root rootData) {
        HashMap<Integer, List<HacFormula>> hacFormulas = new HashMap<Integer, List<HacFormula>>();
        Data.HacFormulaListsRoot hacFormulaLists = rootData.getHacFormulaLists();
        for (Map.Entry<Integer, Data.HacFormulaList> entry : hacFormulaLists.getHacFormulaListsMap().entrySet()) {
            int hacKey = entry.getKey();
            ArrayList<HacFormula> formulas = new ArrayList<HacFormula>();
            for (Data.HacFormulaItem incomingFormula : entry.getValue().getHacFormulaItemsList()) {
                HacFormula formula = new HacFormula();
                formula.setFormula(incomingFormula.getFormula());
                formula.setFormulaCollectionId(incomingFormula.getFormulaCollectionId());
                formula.setHacNumber(incomingFormula.getHacNumber());
                formulas.add(formula);
            }
            hacFormulas.put(hacKey, formulas);
        }
        return hacFormulas;
    }

    @Override
    public boolean isCodeValid(String code) {
        return this.diagnosisAll.containsKey(code.toUpperCase());
    }

    @Override
    public List<String> getDxAttributes(String code) {
        Data.DxPattern pattern;
        Data.Diagnosis dxCode = this.diagnosisAll.get(code.toUpperCase());
        if (dxCode != null && (pattern = this.dxPatterns.get(dxCode.getOperandsPatternNum())) != null) {
            return pattern.getOperandsList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getDxCatAttributes(String code) {
        Data.DxPattern pattern;
        Data.Diagnosis dxCode = this.diagnosisAll.get(code.toUpperCase());
        if (dxCode != null && (pattern = this.dxPatterns.get(dxCode.getDxCatListPatternNum())) != null) {
            return pattern.getOperandsList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getDxHacAttributes(String code) {
        Data.DxPattern pattern;
        Data.Diagnosis dxCode = this.diagnosisAll.get(code.toUpperCase());
        if (dxCode != null && (pattern = this.dxPatterns.get(dxCode.getHacOperandsPatternNum())) != null) {
            return pattern.getOperandsList();
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getExclusionsForCode(String code) {
        Data.ExclusionGroup exclusionGroup;
        Data.PdxExclusionGroup exclusionGroupId = this.exclusionIds.get(code.toUpperCase());
        if (exclusionGroupId != null && (exclusionGroup = this.exclusionGroups.get(exclusionGroupId.getGroupId())) != null) {
            return exclusionGroup.getCodesList();
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<Integer> getClinicalSignificance(String code) {
        Data.Diagnosis dxCode = this.diagnosisAll.get(code.toUpperCase());
        if (dxCode != null) {
            return Optional.of(dxCode.getRank());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ClusterParts> getClusterParts(String clusterCode) {
        ClusterParts parts = new ClusterParts();
        Data.ClusterData clusterData = this.clusterInformation.get(clusterCode.toUpperCase());
        if (clusterData != null) {
            ClusterChoices.ClusterChoicesBuilder choicesBuilder = ClusterChoices.builder();
            for (Data.ClusterChoice clusterChoice : clusterData.getChoicesList()) {
                choicesBuilder.withChoice(clusterChoice.getChoice(), new HashSet<String>(clusterChoice.getCodesList()));
            }
            parts.setChoices(choicesBuilder.build());
            parts.setCodes(new HashSet<String>(clusterData.getCodesList()));
            parts.setSuppressionMdcs(new HashSet<Integer>(clusterData.getSupressionMdcsList()));
            return Optional.of(parts);
        }
        return Optional.empty();
    }

    @Override
    public List<String> getClusterId(String code) {
        Data.CodeToClusterInfo codeToClusterInfo = this.clusterIds.get(code.toUpperCase());
        if (codeToClusterInfo != null) {
            return codeToClusterInfo.getClusterIdsList();
        }
        return Collections.emptyList();
    }

    @Override
    public Map<Integer, Integer> getCodeGenderMdcs(String code) {
        Data.CodeGenderMdc collector = this.genderMdcs.get(code.toUpperCase());
        if (collector == null) {
            return Collections.emptyMap();
        }
        return collector.getGenderMdcMapMap();
    }

    @Override
    public Optional<Integer> getCodeMdc(String code) {
        Data.Diagnosis dxCode = this.diagnosisAll.get(code.toUpperCase());
        if (dxCode != null) {
            return Optional.of(dxCode.getMdc());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getCodeSeverity(String code) {
        Data.Diagnosis dxCode = this.diagnosisAll.get(code.toUpperCase());
        if (dxCode != null) {
            return Optional.of(dxCode.getSeverity());
        }
        return Optional.empty();
    }

    @Override
    public List<MsdrgDrgFormulas> getDrgFormulasForMdc(int mdc) {
        return this.drgFormulas.get(mdc);
    }

    @Override
    public List<String> getHacOperands(String code) {
        Data.HacInfo hacParts = this.hacOperands.get(code.toUpperCase());
        if (hacParts == null) {
            return Collections.emptyList();
        }
        return hacParts.getHacOperandsList();
    }

    @Override
    public List<Integer> getHacNumbers(String code) {
        Data.HacInfo hacParts = this.hacOperands.get(code.toUpperCase());
        if (hacParts == null) {
            return Collections.emptyList();
        }
        return hacParts.getHacNumbersList();
    }

    @Override
    public List<HacFormula> getHacFormulas(int hacNumber) {
        return this.hacFormulas.get(hacNumber);
    }

    @Override
    public List<String> getPrAttributes(String code) {
        Data.PrPattern pattern;
        Data.Procedure procedure = this.procedureAttributes.get(code.toUpperCase());
        if (procedure != null && (pattern = this.prPatterns.get(procedure.getOperandsPatternNum())) != null) {
            return pattern.getOperandsList();
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<String> getDrgDescription(int drg) {
        return Optional.ofNullable(this.drgDescriptions.get(drg));
    }

    @Override
    public Optional<String> getMdcDescription(int mdc) {
        return Optional.ofNullable(this.mdcDescriptions.get(mdc));
    }

    @Override
    public Optional<String> getBaseDrgDescription(int drg) {
        return Optional.ofNullable(this.baseDrgDescriptions.get(drg));
    }

    @Override
    public Optional<String> getHacDescription(int hac) {
        return Optional.ofNullable(this.hacDescriptions.get(hac));
    }
}

