/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.access.dao;

import gov.agency.msdrg.v391.access.blob.DataAccess;
import gov.agency.msdrg.v391.access.blob.dto.ClusterParts;
import gov.agency.msdrg.v391.access.dao.structure.Dao;
import gov.agency.msdrg.v391.access.pojo.MsdrgClusterDefinition;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public final class ClusterAccess
implements Dao<List<String>, Set<MsdrgClusterDefinition>> {
    private final DataAccess dataAccess;

    public ClusterAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    @Override
    public Set<MsdrgClusterDefinition> getData(List<String> procCodes) {
        HashSet<MsdrgClusterDefinition> clusters = new HashSet<MsdrgClusterDefinition>();
        for (String procCode : procCodes) {
            List<String> clusterIds = this.dataAccess.getClusterId(procCode);
            if (clusterIds == null) continue;
            for (String clusterId : clusterIds) {
                Optional<ClusterParts> clusterParts = this.dataAccess.getClusterParts(clusterId);
                clusterParts.ifPresent(parts -> clusters.add(new MsdrgClusterDefinition(clusterId, (ClusterParts)parts)));
            }
        }
        return clusters;
    }
}

