/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic;

import com.mmm.his.cer.foundation.exception.FoundationRuntimeException;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgDiagnosisFlag;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.MsdrgProcedureFlag;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.transfer.MsdrgOutputDxCode;
import gov.agency.msdrg.model.transfer.MsdrgOutputPrCode;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MsdrgCodeFlagsProcessor {
    public static TempFlagsContainer processCodeFlags(ProcessingData processingData, ProcessingContext context) {
        boolean didNotReachFinal;
        MsdrgDischargeStatus dischargeStatus = processingData.getDischargeStatus();
        MsdrgGrouperReturnCode initialGrc = processingData.getInitialResult().getReturnCode();
        int initialDrg = processingData.getInitialResult().getDrg();
        boolean bl = didNotReachFinal = !context.getFinalMatchedFormula().isPresent();
        if (didNotReachFinal && initialDrg != 999) {
            MsdrgCodeFlagsProcessor.setCodeFlagsWhenUngroupable(processingData, dischargeStatus);
        }
        if (initialGrc == MsdrgGrouperReturnCode.INVALID_PDX || initialGrc == MsdrgGrouperReturnCode.DX_CANNOT_BE_PDX) {
            for (MsdrgDiagnosisCode sdxCode : processingData.getSdxCodes()) {
                context.getGroupingType().ifPresent(sdxCode::setSeverityFlag);
            }
        }
        MsdrgOutputDxCode pdxOutput = MsdrgCodeFlagsProcessor.createPdxOutput(processingData);
        List<MsdrgOutputDxCode> sdxOutput = MsdrgCodeFlagsProcessor.createSdxOutput(processingData);
        List<MsdrgOutputPrCode> procFlagMap = MsdrgCodeFlagsProcessor.createProcedureFlagMap(processingData);
        return new TempFlagsContainer(pdxOutput, sdxOutput, procFlagMap);
    }

    private static void setCodeFlagsWhenUngroupable(ProcessingData data, MsdrgDischargeStatus dischargeStatus) {
        data.getSdxCodes().forEach(dxCode -> dxCode.processSeverityFlag(dischargeStatus));
    }

    private static MsdrgOutputDxCode createPdxOutput(ProcessingData data) {
        MsdrgDiagnosisCode processedPdx = data.getPrincipalDx();
        if (processedPdx == null) {
            throw new FoundationRuntimeException("Null PDX encountered while creating flags.");
        }
        MsdrgDiagnosisFlag pdxFlag = new MsdrgDiagnosisFlag(processedPdx.isValidCode(), processedPdx.getDrgImpact(), processedPdx.getFinalSeverityFlag(), processedPdx.getInitialSeverityFlag(), processedPdx.getPoaErrorCodeFlag(), processedPdx.getHacsFlags());
        return new MsdrgOutputDxCode(processedPdx.getInputDxCode(), pdxFlag);
    }

    private static List<MsdrgOutputDxCode> createSdxOutput(ProcessingData data) {
        ArrayList<MsdrgOutputDxCode> sdxOutput = new ArrayList<MsdrgOutputDxCode>();
        for (MsdrgDiagnosisCode processedDxCode : data.getSdxCodes()) {
            if (processedDxCode == null) {
                throw new FoundationRuntimeException("Null SDX encountered while creating flags.");
            }
            if (!processedDxCode.getHacsFlags().isEmpty()) {
                processedDxCode.getHacsFlags().sort(Comparator.comparingInt(MsdrgHac::getHacNumber));
            }
            MsdrgDiagnosisFlag dxFlag = new MsdrgDiagnosisFlag(processedDxCode.isValidCode(), processedDxCode.getDrgImpact(), processedDxCode.getFinalSeverityFlag(), processedDxCode.getInitialSeverityFlag(), processedDxCode.getPoaErrorCodeFlag(), processedDxCode.getHacsFlags());
            sdxOutput.add(new MsdrgOutputDxCode(processedDxCode.getInputDxCode(), dxFlag));
        }
        return sdxOutput;
    }

    private static List<MsdrgOutputPrCode> createProcedureFlagMap(ProcessingData data) {
        ArrayList<MsdrgOutputPrCode> procOutput = new ArrayList<MsdrgOutputPrCode>();
        for (MsdrgProcedureCode processedProcCode : data.getProcedureCodes()) {
            if (processedProcCode == null) {
                throw new FoundationRuntimeException("Null proc encountered while creating flags.");
            }
            MsdrgProcedureFlag procFlag = new MsdrgProcedureFlag(processedProcCode.isValidCode(), processedProcCode.getDrgImpact(), processedProcCode.isOperatingRoomProcedure(), processedProcCode.getHacUsageFlag());
            procOutput.add(new MsdrgOutputPrCode(processedProcCode.getInputPrCode(), procFlag));
        }
        return procOutput;
    }

    @Deprecated
    private static void setCodeSeverity(ProcessingData data, MsdrgDischargeStatus dischargeStatus) {
        throw new UnsupportedOperationException("MsdrgCodeFlagsProcessor.setCodeSeverity() is no longer supported");
    }

    @Deprecated
    private static void modifyCodeSeverityFlag(List<MsdrgDiagnosisCode> sdxCodes) {
        throw new UnsupportedOperationException("MsdrgCodeFlagsProcessor.modifyCodeSeverityFlag() is no longer supported");
    }

    public static class TempFlagsContainer {
        private final MsdrgOutputDxCode pdxFlagMap;
        private final List<MsdrgOutputDxCode> dxFlagMap;
        private final List<MsdrgOutputPrCode> procFlagMap;

        public TempFlagsContainer(MsdrgOutputDxCode pdxFlagMap, List<MsdrgOutputDxCode> dxFlagMap, List<MsdrgOutputPrCode> procFlagMap) {
            this.pdxFlagMap = pdxFlagMap;
            this.dxFlagMap = dxFlagMap;
            this.procFlagMap = procFlagMap;
        }

        public MsdrgOutputDxCode getPdxFlagMap() {
            return this.pdxFlagMap;
        }

        public List<MsdrgOutputDxCode> getDxFlagMap() {
            return this.dxFlagMap;
        }

        public List<MsdrgOutputPrCode> getProcFlagMap() {
            return this.procFlagMap;
        }
    }
}

