/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic;

import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgMedSurgType;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.access.dao.structure.DescriptionDao;

public class MsdrgGrouperResultReport {
    public MsdrgGrouperResult createGrouperResult(int mdc, MsdrgMatchedDrgFormula matchedDrg, MsdrgSeverity severity, DescriptionDao dataAccess) {
        MsdrgGrouperResult.MsdrgGrouperResultBuilder resultBuilder = MsdrgGrouperResult.builder();
        int baseDrg = matchedDrg.getBaseDrg();
        int drg = matchedDrg.getDrg();
        resultBuilder.withMdc(mdc);
        resultBuilder.withBaseDrg(baseDrg);
        resultBuilder.withDrg(drg);
        resultBuilder.withSeverity(severity);
        dataAccess.getDrgDescription(drg).ifPresent(resultBuilder::withDrgDescription);
        dataAccess.getBaseDrgDescription(baseDrg).ifPresent(resultBuilder::withBaseDrgDescription);
        dataAccess.getMdcDescription(mdc).ifPresent(resultBuilder::withMdcDescription);
        if (matchedDrg.getSurgical() != null) {
            if (matchedDrg.getSurgical().equalsIgnoreCase(MsdrgMedSurgType.SURGICAL.name())) {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.SURGICAL);
            } else if (matchedDrg.getSurgical().equalsIgnoreCase(MsdrgMedSurgType.MEDICAL.name())) {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.MEDICAL);
            } else {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.NONE);
            }
        } else {
            resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.NONE);
        }
        resultBuilder.withReturnCode(MsdrgGrouperReturnCode.OK);
        if (drg == 998) {
            resultBuilder.withSeverity(MsdrgSeverity.NONE);
        }
        return resultBuilder.build();
    }
}

