/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.ast;

import com.mmm.his.cer.utility.farser.ast.node.type.BooleanExpression;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NonDrugEludingStentAstNode
implements BooleanExpression<Attribute> {
    private List<MsdrgProcedureCode> orderedCodes;
    private static Map<String, Attribute> stentAttributes = new HashMap<String, Attribute>();

    public NonDrugEludingStentAstNode(List<MsdrgProcedureCode> orderedCodes) {
        this.orderedCodes = orderedCodes;
    }

    @Override
    public boolean evaluate(List<Attribute> operands, Set<Attribute> accumulator) {
        HashMap<String, Attribute> stents = new HashMap<String, Attribute>();
        ArrayList<MsdrgProcedureCode> codesTomark = new ArrayList<MsdrgProcedureCode>();
        int count = 0;
        for (MsdrgProcedureCode code : this.orderedCodes) {
            if (count >= 4) break;
            if (code.hasAttribute(stentAttributes.get("stent1")) && code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) {
                stents.put("stent1", stentAttributes.get("stent1"));
                codesTomark.add(code);
                ++count;
                continue;
            }
            if (code.hasAttribute(stentAttributes.get("stent2")) && code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) {
                stents.put("stent2", stentAttributes.get("stent2"));
                codesTomark.add(code);
                count += 2;
                continue;
            }
            if (code.hasAttribute(stentAttributes.get("stent3")) && code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) {
                stents.put("stent3", stentAttributes.get("stent3"));
                codesTomark.add(code);
                count += 3;
                continue;
            }
            if (!code.hasAttribute(stentAttributes.get("stent4")) || !code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) continue;
            stents.put("stent4", stentAttributes.get("stent4"));
            codesTomark.add(code);
            count += 4;
        }
        if (count >= 4) {
            accumulator.addAll(stents.values());
            for (MsdrgProcedureCode code : codesTomark) {
                code.setStents4(true);
            }
            return true;
        }
        return false;
    }

    static {
        stentAttributes.put("stent1", new Attribute("stent1"));
        stentAttributes.put("stent2", new Attribute("stent2"));
        stentAttributes.put("stent3", new Attribute("stent3"));
        stentAttributes.put("stent4", new Attribute("stent4"));
    }

    public static class NonDrugEludingNodeSupplier
    implements NodeSupplier<DrgLexerToken, Attribute> {
        private List<MsdrgProcedureCode> orderedCodes;

        public void setOrderedCodes(List<MsdrgProcedureCode> orderedCodes) {
            this.orderedCodes = orderedCodes;
        }

        @Override
        public BooleanExpression<Attribute> createNode(DrgLexerToken token) {
            return new NonDrugEludingStentAstNode(this.orderedCodes);
        }
    }
}

