/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.ast;

import com.mmm.his.cer.utility.farser.ast.node.type.BooleanExpression;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VesselAstNode
implements BooleanExpression<Attribute> {
    private List<MsdrgProcedureCode> orderedCodes;
    private static Map<String, Attribute> vesselAttributes = new HashMap<String, Attribute>();

    public VesselAstNode(List<MsdrgProcedureCode> orderedCodes) {
        this.orderedCodes = orderedCodes;
    }

    @Override
    public boolean evaluate(List<Attribute> operands, Set<Attribute> accumulator) {
        HashSet<MsdrgProcedureCode> codesToMark = new HashSet<MsdrgProcedureCode>();
        HashMap<String, Attribute> vessels = new HashMap<String, Attribute>();
        int count = 0;
        for (MsdrgProcedureCode code : this.orderedCodes) {
            if (count >= 4) break;
            if (code.hasAttribute(vesselAttributes.get("vessel1"))) {
                vessels.put("vessel1", vesselAttributes.get("vessel1"));
                codesToMark.add(code);
                ++count;
                continue;
            }
            if (code.hasAttribute(vesselAttributes.get("vessel2"))) {
                vessels.put("vessel2", vesselAttributes.get("vessel2"));
                codesToMark.add(code);
                count += 2;
                continue;
            }
            if (code.hasAttribute(vesselAttributes.get("vessel3"))) {
                vessels.put("vessel3", vesselAttributes.get("vessel3"));
                codesToMark.add(code);
                count += 3;
                continue;
            }
            if (!code.hasAttribute(vesselAttributes.get("vessel4"))) continue;
            vessels.put("vessel4", vesselAttributes.get("vessel4"));
            codesToMark.add(code);
            count += 4;
        }
        if (count >= 4) {
            accumulator.addAll(vessels.values());
            for (MsdrgProcedureCode procCode : codesToMark) {
                procCode.setVessels4(true);
            }
        }
        return count >= 4;
    }

    static {
        vesselAttributes.put("vessel1", new Attribute("vessel1"));
        vesselAttributes.put("vessel2", new Attribute("vessel2"));
        vesselAttributes.put("vessel3", new Attribute("vessel3"));
        vesselAttributes.put("vessel4", new Attribute("vessel4"));
    }

    public static class VesselNodeSupplier
    implements NodeSupplier<DrgLexerToken, Attribute> {
        private List<MsdrgProcedureCode> orderedCodes;

        public void setOrderedCodes(List<MsdrgProcedureCode> orderedCodes) {
            this.orderedCodes = orderedCodes;
        }

        @Override
        public BooleanExpression<Attribute> createNode(DrgLexerToken token) {
            return new VesselAstNode(this.orderedCodes);
        }
    }
}

