/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.exception.FoundationRuntimeException;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v391.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v391.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v391.logic.MsdrgUtility;
import gov.agency.msdrg.v391.logic.finalprocess.MsdrgFinalMarkingLogic;
import gov.agency.msdrg.v391.logic.initialprocess.MsdrgInitialMarkingLogic;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgPdxMdcGrouping
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgPdxMdcGrouping.class);
    private final FormulaDao formulaAccess;
    private final DescriptionDao descriptionAccess;
    private static final String GRC_5 = "grc 5";

    public MsdrgPdxMdcGrouping(FormulaDao formulaAccess, DescriptionDao descriptionAccess) {
        this.formulaAccess = formulaAccess;
        this.descriptionAccess = descriptionAccess;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        Optional<MsdrgMatchedDrgFormula> maybeMatchedFormula;
        Optional<MsdrgMaskBuildingConditions> maybeCondition = context.getGroupingType();
        Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers = context.getSupplierMap();
        LinkedList<Integer> initialMdcs = context.getInitialMdc();
        LinkedList<Integer> finalMdcs = context.getFinalMdc();
        ProcessingData processingData = context.getProcessingData();
        MsdrgMaskBuildingConditions condition = maybeCondition.orElseThrow(() -> new FoundationRuntimeException("Unable to determine grouping type. Cannot proceed."));
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            maybeMatchedFormula = context.getInitialMatchedFormula();
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            maybeMatchedFormula = context.getFinalMatchedFormula();
        } else {
            throw new FoundationException("Invalid grouping type");
        }
        if (maybeMatchedFormula.isPresent() && maybeMatchedFormula.get().getDrg() != 0) {
            return new Link.LinkResult(context, true);
        }
        RuntimeOptions runtimeOptions = context.getRuntime();
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.pdxMdcGrouping(processingData, condition, suppliers, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt(), processingData.getPrincipalDx().getMdc());
        if (evalContainer == null) {
            throw new FoundationException("Could not evaluate formula");
        }
        MsdrgMatchedDrgFormula matchedDrgFormula = evalContainer.getMatchedDrgFormula();
        if (matchedDrgFormula.getFormula() != null && matchedDrgFormula.getFormula().contains(GRC_5)) {
            MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS, this.descriptionAccess);
            processingData.getSdxCodes().forEach(code -> code.setSeverityFlag(condition));
            context = context.toBuilder().withProcessingData(processingData.toBuilder().withInitialResult(grouperResult).withFinalResult(grouperResult).build()).build();
            return new Link.LinkResult(context, false);
        }
        ProcessingContext.ProcessingContextBuilder contextBuilder = context.toBuilder();
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            contextBuilder.withInitialMatchedFormula(matchedDrgFormula);
            initialMdcs.add(processingData.getPrincipalDx().getMdc());
            contextBuilder.withInitialMdc(initialMdcs);
            if (!matchedDrgFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgInitialMarkingLogic initialMarkingLogic = new MsdrgInitialMarkingLogic();
                processingData = initialMarkingLogic.initialMarking(matchedDrgFormula, processingData, processingData.getPrincipalDx().getMdc());
            }
            processingData = processingData.toBuilder().withInitialSeverity(evalContainer.getSeverity()).build();
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            contextBuilder.withFinalMatchedFormula(matchedDrgFormula);
            finalMdcs.add(processingData.getPrincipalDx().getMdc());
            contextBuilder.withFinalMdc(finalMdcs);
            if (!matchedDrgFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgFinalMarkingLogic finalMarkingLogic = new MsdrgFinalMarkingLogic();
                processingData = finalMarkingLogic.finalMarking(matchedDrgFormula, processingData, processingData.getPrincipalDx().getMdc());
            }
            processingData = processingData.toBuilder().withFinalSeverity(evalContainer.getSeverity()).build();
        }
        contextBuilder.withProcessingData(processingData);
        return new Link.LinkResult(contextBuilder.build(), true);
    }

    private MsdrgFormulaEvaluation.EvalContainer pdxMdcGrouping(ProcessingData processingData, MsdrgMaskBuildingConditions condition, Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers, MsdrgAffectDrgOptionFlag computeAffectDrg, MsdrgHospitalStatusOptionFlag hospitalStatus, int mdc) {
        logger.debug("Reroute and premdc didn't find results");
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        logger.debug("Try grouping with mdc: {}", (Object)mdc);
        MsdrgFormulaEvaluation formulaEvaluation = new MsdrgFormulaEvaluation(this.formulaAccess);
        formulaEvaluation.setSuppliers(suppliers);
        return formulaEvaluation.evaluateFormulas(processingData.getSdxCodes(), condition, mdc, mask, computeAffectDrg, hospitalStatus);
    }
}

