/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.finalprocess;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgCode;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.enumeration.MsdrgProcedureHacUsage;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.ProcessingData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MsdrgFinalMarkingLogic {
    private static final Set<Integer> UNRELATED_DRGS = new HashSet<Integer>(Arrays.asList(981, 982, 983, 987, 988, 989));
    private static final Set<String> COMPLETE_SYSTEM = new HashSet<String>(Collections.singletonList("revision"));

    public ProcessingData finalMarking(MsdrgMatchedDrgFormula matchedFormula, ProcessingData processingData, int mdcInput) {
        int mdc = mdcInput;
        MsdrgDiagnosisCode principalDx = processingData.getPrincipalDx();
        List<MsdrgDiagnosisCode> sdxCodes = processingData.getSdxCodes();
        List<MsdrgProcedureCode> procedureCodes = processingData.getProcedureCodes();
        List<MsdrgProcedureCode> clusters = processingData.getClusters();
        MsdrgProcedureCode principalProc = processingData.getPrincipalProc();
        MsdrgGrouperResult initialResult = processingData.getInitialResult();
        MsdrgGrouperResult finalResult = processingData.getFinalResult();
        if (UNRELATED_DRGS.contains(matchedFormula.getDrg())) {
            sdxCodes.forEach(MsdrgCode::resetFlagsFinal);
            procedureCodes.forEach(MsdrgCode::resetFlagsFinal);
            mdc = 29;
        }
        MsdrgGrouperReturnCode returnCode = null;
        if (finalResult != null) {
            returnCode = finalResult.getReturnCode();
        }
        if (returnCode != MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS && returnCode != MsdrgGrouperReturnCode.HAC_MISSING_ONE_POA && returnCode != MsdrgGrouperReturnCode.HAC_STATUS_INVALID_MULT_HACS_POA_NOT_Y_W && returnCode != MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_INVALID_OR_1 && returnCode != MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_N_OR_U) {
            this.principalDxMarkingLogic(principalDx);
        }
        this.markSpecialFunctionsDiagnosis(matchedFormula.getMatchedAttributes(), sdxCodes, principalDx);
        this.markSpecialFunctionsProcedure(matchedFormula.getMatchedAttributes(), procedureCodes);
        if (!procedureCodes.isEmpty()) {
            this.procedureMarkingLogic(matchedFormula, procedureCodes, clusters, mdc, principalProc, initialResult.getDrg(), matchedFormula.getDrg(), sdxCodes);
        }
        if (!sdxCodes.isEmpty()) {
            this.diagnosisMarkingLogic(matchedFormula.getMatchedAttributes(), sdxCodes, principalDx);
        }
        if (initialResult.getDrg() != matchedFormula.getDrg()) {
            for (MsdrgDiagnosisCode dxCode : sdxCodes) {
                if (!dxCode.hasHacs()) continue;
                dxCode.setFinalMarked(true);
                MsdrgGroupingImpact impact = this.impactMarking(dxCode.getDrgImpact());
                dxCode.setDrgImpact(impact);
            }
        }
        return processingData.toBuilder().withPdx(principalDx).withSdxCodes(sdxCodes).withProcedures(procedureCodes).withClusters(clusters).withPrincipalProcedure(principalProc).build();
    }

    private void principalDxMarkingLogic(MsdrgDiagnosisCode pdx) {
        pdx.setDrgImpact(MsdrgGroupingImpact.BOTH);
        pdx.setInitialMarked(true);
        pdx.setFinalMarked(true);
    }

    private void markProcsThatWereUseInHacFormula(List<MsdrgProcedureCode> procCodes, int initialDrg, int finalDrg, List<MsdrgDiagnosisCode> dxCodes, int mdc) {
        for (MsdrgProcedureCode procCode : procCodes) {
            if (procCode.getHacUsageFlag().isEmpty() || initialDrg == finalDrg || procCode.getMdcSuppression().get(mdc)) continue;
            for (MsdrgProcedureHacUsage hac : procCode.getHacUsageFlag()) {
                if (!this.getAllHacNumbersWhereCriteriaIsMet(dxCodes).contains(hac.getHacValue())) continue;
                procCode.setDrgImpact(this.impactMarking(procCode.getDrgImpact()));
            }
        }
    }

    private Set<Integer> getAllHacNumbersWhereCriteriaIsMet(List<MsdrgDiagnosisCode> dxCodes) {
        HashSet<Integer> hacNumbers = new HashSet<Integer>();
        for (MsdrgDiagnosisCode dxCode : dxCodes) {
            if (dxCode.getHacs().isEmpty()) continue;
            for (MsdrgHac hac : dxCode.getHacs()) {
                if (hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                hacNumbers.add(hac.getHacNumber());
            }
        }
        return hacNumbers;
    }

    private boolean multipleProcsHaveSameAttribute(Attribute attr, List<MsdrgProcedureCode> procCodes, int mdc) {
        int counter = 0;
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            ++counter;
        }
        return counter >= 2;
    }

    private boolean completeSystemTieBreaker(Attribute attr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusters, int mdc, MsdrgProcedureCode principalProc) {
        ArrayList<MsdrgProcedureCode> procCodesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        ArrayList<MsdrgProcedureCode> clusterCodesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            procCodesWithAttribute.add(procCode);
        }
        for (MsdrgProcedureCode cluster : clusters) {
            if (!cluster.hasAttribute(attr)) continue;
            clusterCodesWithAttribute.add(cluster);
        }
        if (!procCodesWithAttribute.isEmpty() && !clusterCodesWithAttribute.isEmpty()) {
            if (principalProc.hasAttribute(attr)) {
                MsdrgGroupingImpact impact = this.impactMarking(principalProc.getDrgImpact());
                principalProc.setDrgImpact(impact);
                principalProc.setFinalMarked(true);
                return true;
            }
            Iterator<MsdrgProcedureCode> iterator = procCodesWithAttribute.iterator();
            if (iterator.hasNext()) {
                MsdrgProcedureCode procCode;
                procCode = iterator.next();
                MsdrgGroupingImpact impact = this.impactMarking(procCode.getDrgImpact());
                procCode.setFinalMarked(true);
                procCode.setDrgImpact(impact);
                return true;
            }
        }
        return false;
    }

    private boolean operatingRoomTieBreaking(Attribute attr, List<MsdrgProcedureCode> procCodes, int mdc, MsdrgProcedureCode principalProc) {
        ArrayList<MsdrgProcedureCode> codesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            codesWithAttribute.add(procCode);
        }
        if (principalProc.hasAttribute(attr) && !principalProc.getMdcSuppression().get(mdc) && principalProc.isOperatingRoomProcedure()) {
            principalProc.setFinalMarked(true);
            MsdrgGroupingImpact impact = this.impactMarking(principalProc.getDrgImpact());
            principalProc.setDrgImpact(impact);
        } else {
            for (MsdrgProcedureCode procCode : codesWithAttribute) {
                if (!procCode.isOperatingRoomProcedure()) continue;
                MsdrgGroupingImpact impact = this.impactMarking(procCode.getDrgImpact());
                procCode.setFinalMarked(true);
                procCode.setDrgImpact(impact);
                return true;
            }
        }
        return false;
    }

    private List<Attribute> getOnlyProcedureAttributes(MsdrgMatchedDrgFormula matchedAttr) {
        ArrayList<Attribute> procAttributes = new ArrayList<Attribute>();
        for (Attribute attr : matchedAttr.getMatchedAttributes()) {
            if (attr.getPrefix() != MsdrgAttributePrefix.NONE || attr.getListName().equals(MsdrgSeverity.MCC.name()) || attr.getListName().equals(MsdrgSeverity.CC.name()) || attr.getListName().equals(MsdrgSeverity.NON_CC.name())) continue;
            procAttributes.add(attr);
        }
        return procAttributes;
    }

    private boolean oneProcForAllAttributes(MsdrgMatchedDrgFormula matchedAttr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusterCodes, int mdc) {
        List<Attribute> procAttributes = this.getOnlyProcedureAttributes(matchedAttr);
        if (!procAttributes.isEmpty()) {
            for (MsdrgProcedureCode procCode : procCodes) {
                if (!procCode.isFirstPosition() || procCode.getMdcSuppression().get(mdc) || !procCode.getAttributes().containsAll(procAttributes)) continue;
                procCode.setFinalMarked(true);
                procCode.setDrgImpact(this.impactMarking(procCode.getDrgImpact()));
                return true;
            }
            for (MsdrgProcedureCode procCode : procCodes) {
                if (procCode.getMdcSuppression().get(mdc) || !procCode.getAttributes().containsAll(procAttributes)) continue;
                procCode.setFinalMarked(true);
                procCode.setDrgImpact(this.impactMarking(procCode.getDrgImpact()));
                return true;
            }
            for (MsdrgProcedureCode cluster : clusterCodes) {
                if (!cluster.getAttributes().containsAll(procAttributes)) continue;
                TreeSet<String> procValues = new TreeSet<String>();
                for (MsdrgProcedureCode procCode : procCodes) {
                    if (!procCode.getClusterIds().contains(cluster.getValue()) || procValues.contains(procCode.getValue())) continue;
                    procValues.add(procCode.getValue());
                    procCode.setFinalMarked(true);
                    procCode.setDrgImpact(this.impactMarking(procCode.getDrgImpact()));
                }
                return true;
            }
        }
        return false;
    }

    private void procedureMarkingLogic(MsdrgMatchedDrgFormula matchedAttr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusterCodes, int mdc, MsdrgProcedureCode principalProcCode, int initialDrg, int finalDrg, List<MsdrgDiagnosisCode> dxCodes) {
        if (!this.oneProcForAllAttributes(matchedAttr, procCodes, clusterCodes, mdc)) {
            block0: for (Attribute attr : matchedAttr.getMatchedAttributes()) {
                if (COMPLETE_SYSTEM.contains(attr.getListName()) && this.completeSystemTieBreaker(attr, procCodes, clusterCodes, mdc, principalProcCode)) continue;
                if (this.multipleProcsHaveSameAttribute(attr, procCodes, mdc)) {
                    if (principalProcCode.hasAttribute(attr) && !principalProcCode.getMdcSuppression().get(mdc)) {
                        principalProcCode.setFinalMarked(true);
                        MsdrgGroupingImpact impact = this.impactMarking(principalProcCode.getDrgImpact());
                        principalProcCode.setDrgImpact(impact);
                        continue;
                    }
                    for (MsdrgProcedureCode procCode : procCodes) {
                        if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
                        procCode.setFinalMarked(true);
                        MsdrgGroupingImpact impact = this.impactMarking(procCode.getDrgImpact());
                        procCode.setDrgImpact(impact);
                        continue block0;
                    }
                    continue;
                }
                boolean matchFound = false;
                for (MsdrgProcedureCode procCode : procCodes) {
                    if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
                    MsdrgGroupingImpact impact = this.impactMarking(procCode.getDrgImpact());
                    procCode.setFinalMarked(true);
                    procCode.setDrgImpact(impact);
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                for (MsdrgProcedureCode cluster : clusterCodes) {
                    if (!cluster.hasAttribute(attr)) continue;
                    TreeSet<String> codeValues = new TreeSet<String>();
                    for (MsdrgProcedureCode procCode : procCodes) {
                        if (!procCode.getClusterIds().contains(cluster.getValue()) || codeValues.contains(procCode.getValue())) continue;
                        codeValues.add(procCode.getValue());
                        MsdrgGroupingImpact impact = this.impactMarking(procCode.getDrgImpact());
                        procCode.setFinalMarked(true);
                        procCode.setDrgImpact(impact);
                    }
                    continue block0;
                }
            }
        }
        this.markProcsThatWereUseInHacFormula(procCodes, initialDrg, finalDrg, dxCodes, mdc);
    }

    private void diagnosisMarkingLogic(Set<Attribute> attr, List<MsdrgDiagnosisCode> dxCodes, MsdrgDiagnosisCode pdx) {
        TreeSet<Attribute> matchedAttributes = new TreeSet<Attribute>(attr);
        TreeSet<Attribute> attrToRemove = new TreeSet<Attribute>();
        for (MsdrgDiagnosisCode dxCode : dxCodes) {
            for (Attribute attribute : matchedAttributes) {
                MsdrgGroupingImpact impact;
                if (dxCode.isFinalMarked() && dxCode.getAttributeMarkedFor() == attribute) {
                    attrToRemove.add(attribute);
                    break;
                }
                if (attribute.equals(new Attribute(MsdrgAttributePrefix.ONLY, "incident")) || pdx.hasAttribute(attribute.getListName()) && (attribute.getPrefix().equals((Object)MsdrgAttributePrefix.PDX) || attribute.getPrefix().equals((Object)MsdrgAttributePrefix.ANY))) continue;
                if ((attribute.getListName().equalsIgnoreCase(MsdrgSeverity.MCC.name()) || attribute.getListName().equalsIgnoreCase(MsdrgSeverity.CC.name())) && !dxCode.hasHacs() && !dxCode.isDowngradeSeverityDueToSuppression() && !dxCode.isExcluded() && dxCode.getSeverity().toString().equalsIgnoreCase(attribute.getListName())) {
                    dxCode.setFinalMarked(true);
                    impact = this.impactMarking(dxCode.getDrgImpact());
                    dxCode.setDrgImpact(impact);
                    dxCode.setAttributeMarkedFor(attribute);
                    attrToRemove.add(attribute);
                    break;
                }
                if (attribute.getPrefix() != MsdrgAttributePrefix.SDX && attribute.getPrefix() != MsdrgAttributePrefix.ANY || !dxCode.hasAttribute(attribute.getListName())) continue;
                dxCode.setFinalMarked(true);
                impact = this.impactMarking(dxCode.getDrgImpact());
                dxCode.setDrgImpact(impact);
                dxCode.setAttributeMarkedFor(attribute);
                attrToRemove.add(attribute);
                break;
            }
            matchedAttributes.removeAll(attrToRemove);
        }
    }

    public void markSpecialFunctionsDiagnosis(Set<Attribute> matchedAttributes, List<MsdrgDiagnosisCode> dxCodes, MsdrgDiagnosisCode pdx) {
        this.markSigTrauma(matchedAttributes, dxCodes, pdx);
    }

    private void markSpecialFunctionsProcedure(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        this.markStents(matchedAttributes, procedureCodes);
        this.markVessels(matchedAttributes, procedureCodes);
    }

    private void markSigTrauma(Set<Attribute> matchedAttributes, List<MsdrgDiagnosisCode> dxCodes, MsdrgDiagnosisCode pdx) {
        int sigTraumaCounter = 0;
        if (pdx.isSigTrauma()) {
            pdx.setFinalMarked(true);
            pdx.setDrgImpact(this.impactMarking(pdx.getDrgImpact()));
            ++sigTraumaCounter;
        }
        if (matchedAttributes.contains(new Attribute("sthead")) || matchedAttributes.contains(new Attribute("stchest")) || matchedAttributes.contains(new Attribute("stabdom")) || matchedAttributes.contains(new Attribute("stkidney")) || matchedAttributes.contains(new Attribute("sturin")) || matchedAttributes.contains(new Attribute("stpel")) || matchedAttributes.contains(new Attribute("stuplimb")) || matchedAttributes.contains(new Attribute("stlolimb"))) {
            for (MsdrgDiagnosisCode dxCode : dxCodes) {
                if (!dxCode.isSigTrauma() || sigTraumaCounter >= 2) continue;
                dxCode.setFinalMarked(true);
                MsdrgGroupingImpact impact = this.impactMarking(dxCode.getDrgImpact());
                dxCode.setDrgImpact(impact);
                ++sigTraumaCounter;
            }
            TreeSet<Attribute> attrs = new TreeSet<Attribute>();
            attrs.add(new Attribute("sthead"));
            attrs.add(new Attribute("stchest"));
            attrs.add(new Attribute("stabdom"));
            attrs.add(new Attribute("stkidney"));
            attrs.add(new Attribute("sturin"));
            attrs.add(new Attribute("stpel"));
            attrs.add(new Attribute("stuplimb"));
            attrs.add(new Attribute("stlolimb"));
            matchedAttributes.removeAll(attrs);
        }
    }

    private void markStents(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        attrs.add(new Attribute("stent1"));
        attrs.add(new Attribute("stent2"));
        attrs.add(new Attribute("stent3"));
        attrs.add(new Attribute("stent4"));
        attrs.add(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()));
        attrs.add(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()));
        attrs.add(new Attribute("arterial"));
        if (matchedAttributes.contains(new Attribute("stent1")) || matchedAttributes.contains(new Attribute("stent2")) || matchedAttributes.contains(new Attribute("stent3")) || matchedAttributes.contains(new Attribute("stent4"))) {
            MsdrgGroupingImpact impact;
            for (MsdrgProcedureCode procCode : procedureCodes) {
                if (!procCode.isStents4()) continue;
                impact = this.impactMarking(procCode.getDrgImpact());
                procCode.setDrgImpact(impact);
                procCode.setFinalMarked(true);
            }
            if (matchedAttributes.contains(new Attribute("arterial")) && matchedAttributes.contains(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) {
                for (MsdrgProcedureCode code : procedureCodes) {
                    if (code.isFinalMarked() || !code.hasAttribute(new Attribute("arterial")) || !code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) continue;
                    code.setFinalMarked(true);
                    impact = this.impactMarking(code.getDrgImpact());
                    code.setDrgImpact(impact);
                }
            } else if (matchedAttributes.contains(new Attribute("arterial")) && matchedAttributes.contains(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) {
                for (MsdrgProcedureCode code : procedureCodes) {
                    if (code.isFinalMarked() || !code.hasAttribute(new Attribute("arterial")) || !code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) continue;
                    code.setFinalMarked(true);
                    impact = this.impactMarking(code.getDrgImpact());
                    code.setDrgImpact(impact);
                }
            }
            matchedAttributes.removeAll(attrs);
        }
    }

    private void markVessels(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        if (matchedAttributes.contains(new Attribute("vessel1")) || matchedAttributes.contains(new Attribute("vessel2")) || matchedAttributes.contains(new Attribute("vessel3")) || matchedAttributes.contains(new Attribute("vessel4"))) {
            for (MsdrgProcedureCode procCode : procedureCodes) {
                if (!procCode.isVessels4()) continue;
                procCode.setFinalMarked(true);
                MsdrgGroupingImpact impact = this.impactMarking(procCode.getDrgImpact());
                procCode.setDrgImpact(impact);
            }
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            attrs.add(new Attribute("vessel1"));
            attrs.add(new Attribute("vessel2"));
            attrs.add(new Attribute("vessel3"));
            attrs.add(new Attribute("vessel4"));
            matchedAttributes.removeAll(attrs);
        }
    }

    public MsdrgGroupingImpact impactMarking(MsdrgGroupingImpact existingImpact) {
        if (existingImpact == MsdrgGroupingImpact.BOTH) {
            return MsdrgGroupingImpact.BOTH;
        }
        if (existingImpact == MsdrgGroupingImpact.INITIAL) {
            return MsdrgGroupingImpact.BOTH;
        }
        return MsdrgGroupingImpact.FINAL;
    }
}

