/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.preprocess;

import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.Dao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgExclusions
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgExclusions.class);
    private static final String MCC_ALIVE = "mccalive";
    private final Dao<String, List<String>> exclusionAccess;

    public MsdrgExclusions(Dao<String, List<String>> access) {
        this.exclusionAccess = access;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        ProcessingData processingData = context.getProcessingData();
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        String pdx = processingData.getPrincipalDx().getValue();
        logger.debug("Begin processing exclusions");
        List<Object> exclusions = new ArrayList();
        try {
            exclusions = this.processExclusions(pdx, sdxCodes, this.exclusionAccess);
        }
        catch (IOException | SQLException exception) {
            exception.printStackTrace();
        }
        if (processingData.getDischargeStatus() == MsdrgDischargeStatus.DIED) {
            logger.debug("Discharge status of death so process death exclusions");
            exclusions = this.deathExclusions(sdxCodes);
            logger.debug("Death exclusions processed");
        }
        logger.debug("Exclusions processed");
        if (!exclusions.isEmpty()) {
            context = context.toBuilder().withProcessingData(processingData.toBuilder().withSdxCodes(exclusions).build()).build();
        }
        return new Link.LinkResult(context, true);
    }

    private List<MsdrgDiagnosisCode> processExclusions(String pdx, List<MsdrgDiagnosisCode> sdxCodes, Dao<String, List<String>> access) throws IOException, SQLException {
        List<String> exclusionCodes = access.getData(pdx);
        logger.debug("Exclusions retrieved for code: {}", (Object)pdx);
        for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
            if (!exclusionCodes.contains(sdxCode.getValue())) continue;
            sdxCode.setExcluded(true);
        }
        return sdxCodes;
    }

    private List<MsdrgDiagnosisCode> deathExclusions(List<MsdrgDiagnosisCode> sdxCodes) {
        for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
            if (sdxCode.getAttributes() == null || !sdxCode.hasAttribute(MCC_ALIVE)) continue;
            sdxCode.setExcluded(true);
        }
        return sdxCodes;
    }
}

