/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400;

import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSex;
import gov.agency.msdrg.model.v2.transfer.MsdrgClaim;
import gov.agency.msdrg.v400.access.blob.dto.HacFormula;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.Consumer;

public class TraceUtility {
    private Consumer<String> consumer = null;

    public TraceUtility() {
        this(null);
    }

    public TraceUtility(Consumer<String> traceConsumer) {
        this.consumer = traceConsumer;
    }

    public void traceClaim(MsdrgClaim claim) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        String sex = claim.getInput().getSex().orElse(MsdrgSex.UNKNOWN).toString();
        String dischargeStatus = claim.getInput().getDischargeStatus().orElse(MsdrgDischargeStatus.NONE).toString();
        traceResults.append("\n=================\n").append("Case:").append(claim.getClaimId()).append("\tAge Yrs:").append(claim.getInput().getAgeInYears()).append("\tAge Days Admit:").append(claim.getInput().getAgeDaysAdmit()).append("\tAge Days Disch:").append(claim.getInput().getAgeDaysDischarge()).append("\tSex:").append(sex).append("\tDischarge Status:").append(dischargeStatus).append("\n");
        this.consumer.accept(traceResults.toString());
    }

    public void tracePdxCode(MsdrgDiagnosisCode pdx) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        String mdcValue = "";
        if (pdx.is(MsdrgCode.CodeFlag.VALID)) {
            mdcValue = String.valueOf(pdx.getMdc());
        }
        traceResults.append("\nPDX:").append(pdx.getValue()).append("\tPOA:").append(pdx.getPoa().toString()).append("\tMDC:").append(mdcValue).append("\tDXCAT:").append(this.traceAttributes(pdx.getDxCatAttributes())).append("\tAttributes:[").append(this.traceAttributes(pdx.getAttributes())).append("]");
        this.consumer.accept(traceResults.toString());
    }

    public void traceSdxCodes(List<MsdrgDiagnosisCode> sdxCodes) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        if (sdxCodes.size() == 0) {
            traceResults.append("\n<No Secondary Diagnoses>");
        } else {
            for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
                traceResults.append("\nSDX:").append(sdxCode.getValue()).append("\tPOA:").append(sdxCode.getPoa().toString()).append("\tclinSig:").append(sdxCode.getClinicalSignificanceRank()).append("\tAttributes:[").append(this.traceAttributes(sdxCode.getAttributes())).append("]").append("\tSev:").append(sdxCode.getSeverity() == null ? MsdrgSeverity.NONE.toString() : sdxCode.getSeverity().toString()).append("\tHAC:").append(this.traceAttributes(sdxCode.getHacAttributes())).append("]");
            }
        }
        this.consumer.accept(traceResults.toString());
    }

    public void traceProcedureCodes(List<MsdrgProcedureCode> procCodes) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        if (procCodes.size() == 0) {
            traceResults.append("\n<No Procedures>");
        } else {
            for (MsdrgProcedureCode code : procCodes) {
                traceResults.append("\nPROC:").append(code.getValue()).append("\tAttributes:[").append(this.traceAttributes(code.getAttributes())).append("]").append("\tHAC:").append(code.getHacUsageFlag());
            }
        }
        this.consumer.accept(traceResults.toString());
    }

    public void traceClustersCodes(List<MsdrgProcedureCode> procCodes) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        TreeMap<String, Set> clusterIds = new TreeMap<String, Set>();
        for (MsdrgProcedureCode code : procCodes) {
            if (code.getClusterIds().size() <= 0) continue;
            for (String clusId : code.getClusterIds()) {
                Set clusMember = clusterIds.getOrDefault(clusId, new HashSet());
                clusMember.add(code.getValue());
                clusterIds.put(clusId, clusMember);
            }
        }
        for (MsdrgProcedureCode code : procCodes) {
            traceResults.append("\nPROC:").append(code.getValue()).append("\tAttributes:[").append(this.traceAttributes(code.getAttributes())).append("]").append("\tHAC:").append(code.getHacUsageFlag()).append("\tMDC Suppression:").append(code.getMdcSuppression());
            if (clusterIds.get(code.getValue()) == null) continue;
            for (String clusMembers : (Set)clusterIds.get(code.getValue())) {
                traceResults.append("\t").append(clusMembers);
            }
        }
        this.consumer.accept(traceResults.toString());
    }

    private String traceAttributes(Collection<Attribute> codeAttributesAsSet) {
        if (codeAttributesAsSet == null) {
            return "";
        }
        StringJoiner attributes = new StringJoiner("\t");
        for (Attribute attrib : codeAttributesAsSet) {
            attributes.add(attrib.getListName());
        }
        return attributes.toString();
    }

    public void traceGrouperResults(MsdrgGroupingImpact initialOrFinal, MsdrgGrouperResult results) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        traceResults.append("\n\n***").append((Object)initialOrFinal).append(" DRG Grouping Results\n");
        if (results == null) {
            traceResults.append("\n<No results>");
        } else {
            traceResults.append("\tGRC:").append(results.getReturnCode().toString()).append("\n\tMDC:").append(results.getMdc()).append(" ").append(results.getMdcDescription()).append("\n\tDRG:").append(results.getDrg()).append(" ").append(results.getDrgDescription()).append("\n\tM/S:").append(results.getMedicalOrSurgical().toString()).append("\n\tSev:").append(results.getSeverity().toString());
        }
        this.consumer.accept(traceResults.toString());
    }

    public void traceMdc(AstContext context) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        traceResults.append("\n\tAnalyzing MDC ").append(context.getMdc()).append(" with mask [").append(this.traceAttributes(context.getMask())).append("]");
        this.consumer.accept(traceResults.toString());
    }

    public void traceDrgFormula(MsdrgMatchedDrgFormula matchedDrgFormula) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        traceResults.append("\n\t\t->Match on DRG ").append(matchedDrgFormula.getDrg()).append(" with formula (").append(matchedDrgFormula.getFormula()).append(")");
        this.consumer.accept(traceResults.toString());
    }

    public void traceHacFormula(HacFormula matchedHacFormula) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        traceResults.append("\n***HAC Processing info:");
        traceResults.append("\n\t\t->Match on HAC ").append(matchedHacFormula.getHacNumber()).append(" with formula (").append(matchedHacFormula.getFormula()).append(")");
        this.consumer.accept(traceResults.toString());
    }

    public void traceHac(ProcessingContext context) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        if (context.getRuntime().getPoaReportingExempt() == MsdrgHospitalStatusOptionFlag.EXEMPT) {
            traceResults.append("\n<claim exempt from HAC processing>");
        } else {
            for (MsdrgDiagnosisCode dxCode : context.getProcessingData().getSdxCodes()) {
                this.traceHacDiagnosisCodeInfo(dxCode);
            }
            for (MsdrgProcedureCode procCode : context.getProcessingData().getProcedureCodes()) {
                this.traceHacProcedureCodeInfo(procCode);
            }
        }
        traceResults.append("\n***");
        this.consumer.accept(traceResults.toString());
    }

    public void traceHacDiagnosisCodeInfo(MsdrgDiagnosisCode code) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        if (!code.getHacs().isEmpty()) {
            traceResults.append("\t\t\tSDX :").append(code.getValue()).append("\tPOA:").append(code.getPoa()).append("\tPOA status:").append((Object)code.getPoaErrorCodeFlag());
            for (MsdrgHac hac : code.getHacs()) {
                traceResults.append("\t\t\tHAC :").append(hac.getHacList()).append("\tHAC Status:").append((Object)hac.getHacStatus());
            }
        }
        this.consumer.accept(traceResults.toString());
    }

    public void traceHacProcedureCodeInfo(MsdrgProcedureCode code) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        traceResults.append("\t\t\tPROC:").append(code.getValue()).append("\tUsage:").append(code.getHacUsageFlag());
        this.consumer.accept(traceResults.toString());
    }

    public void traceExclusions(List<MsdrgDiagnosisCode> sdxCodes) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        if (sdxCodes.size() != 0) {
            traceResults.append("\n***Exclusion info:");
            for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
                if (sdxCode.is(MsdrgCode.CodeFlag.EXCLUDED)) {
                    traceResults.append("\n\tSDX:").append(sdxCode.getValue()).append(" Excluded by PDX");
                    continue;
                }
                if (!sdxCode.is(MsdrgCode.CodeFlag.DEATH_EXCLUSION)) continue;
                traceResults.append("\n\tSDX:").append(sdxCode.getValue()).append(" Excluded by Death (given by Discharge Status)");
            }
        }
        traceResults.append("\n***");
        this.consumer.accept(traceResults.toString());
    }

    public void traceAffectMarking(ProcessingContext context) {
        if (this.consumer == null) {
            return;
        }
        StringBuilder traceResults = new StringBuilder();
        traceResults.append("\n***Affect Flag marking:");
        for (MsdrgDiagnosisCode sdxCode : context.getProcessingData().getSdxCodes()) {
            if (sdxCode.getDrgImpact().equals((Object)MsdrgGroupingImpact.NONE)) continue;
            traceResults.append("\n\tSDX:").append(sdxCode.getValue()).append(" ->").append((Object)sdxCode.getDrgImpact());
        }
        for (MsdrgProcedureCode procCode : context.getProcessingData().getProcedureCodes()) {
            if (procCode.getDrgImpact().equals((Object)MsdrgGroupingImpact.NONE)) continue;
            traceResults.append("\n\tProc:").append(procCode.getValue()).append(" ->").append((Object)procCode.getDrgImpact());
        }
        traceResults.append("\n***");
        this.consumer.accept(traceResults.toString());
    }
}

