/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.access.dao.structure.DiagnosisDao;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class DiagnosisAttributeProcessor {
    private static final String NCC = "NCC";
    protected final DiagnosisDao diagnosisAccess;

    public DiagnosisAttributeProcessor(DiagnosisDao diagnosisAccess) {
        this.diagnosisAccess = diagnosisAccess;
    }

    protected Set<Attribute> getSdxAttributes(MsdrgDiagnosisCode code) {
        return this.diagnosisAccess.getAttributesForSecondaryDiagnosis(code.getValue());
    }

    protected Set<Attribute> getPdxAttributes(MsdrgDiagnosisCode code) {
        return this.diagnosisAccess.getAttributesForPrincipalDiagnosis(code.getValue());
    }

    protected Set<Attribute> getPdxHacAttributes(MsdrgDiagnosisCode code) {
        return this.diagnosisAccess.getDxHacAttributesForPdx(code.getValue());
    }

    protected Set<Attribute> getSdxHacAttributes(MsdrgDiagnosisCode code) {
        return this.diagnosisAccess.getDxHacAttributesForSdx(code.getValue());
    }

    protected Set<Attribute> getPdxDxCatAttributes(MsdrgDiagnosisCode code) {
        return this.diagnosisAccess.getDxCatListForPdx(code.getValue());
    }

    protected Set<Attribute> getSdxDxCatAttributes(MsdrgDiagnosisCode code) {
        return this.diagnosisAccess.getDxCatListForSdx(code.getValue());
    }

    protected List<MsdrgHac> getDiagnosisHac(MsdrgDiagnosisCode code) {
        return this.diagnosisAccess.getHacsForCode(code.getValue());
    }

    protected MsdrgSeverity getDiagnosisSeverity(MsdrgDiagnosisCode code) throws IOException, SQLException {
        return MsdrgSeverity.from(this.diagnosisAccess.getSeverityOfCode(code.getValue()).orElse(NCC));
    }

    protected int getDiagnosisMdc(MsdrgDiagnosisCode code) throws IOException, SQLException {
        return this.diagnosisAccess.getMdcOfCode(code.getValue()).orElse(-1);
    }
}

