/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.ast.ContainsNode;
import gov.agency.msdrg.v400.logic.ast.SuppressionContainsNode;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.utility.farser.ast.DrgSyntaxTree;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.BooleanExpression;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.ast.parser.DescentParser;
import gov.agency.msdrg.v400.utility.farser.ast.parser.ExpressionResult;
import gov.agency.msdrg.v400.utility.farser.lexer.DrgFormulaLexer;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FormulaEvaluator {
    protected Map<String, NodeSupplier<DrgLexerToken, AstContext>> suppliers;
    protected NodeSupplier<DrgLexerToken, AstContext> defaultSupplier = FormulaEvaluator::createContainsNode;
    protected NodeSupplier<DrgLexerToken, AstContext> defaultSuppressionSupplier = FormulaEvaluator::createSuppressionContainsNode;
    protected static Map<String, List<DrgLexerToken>> lexedFormulas = new ConcurrentHashMap<String, List<DrgLexerToken>>();

    protected FormulaEvaluator() {
    }

    protected ExpressionResult<AstContext> evaluateFormula(AstContext context, String formula) {
        return this.doEvaluate(this.defaultSuppressionSupplier, context, formula);
    }

    protected ExpressionResult<AstContext> evaluateFormulaWithoutSuppression(AstContext context, String formula) {
        return this.doEvaluate(this.defaultSupplier, context, formula);
    }

    private ExpressionResult<AstContext> doEvaluate(NodeSupplier<DrgLexerToken, AstContext> defaultNodeSupplier, AstContext context, String formula) {
        List lexerTokens = lexedFormulas.computeIfAbsent(formula, key -> DrgFormulaLexer.lex(formula));
        DescentParser<AstContext> parser = new DescentParser<AstContext>(lexerTokens.listIterator(), defaultNodeSupplier, this.suppliers);
        DrgSyntaxTree<AstContext> syntaxTree = parser.buildExpressionTree();
        return syntaxTree.evaluateExpression(context);
    }

    public static void lexFormula(String formula) {
        lexedFormulas.computeIfAbsent(formula, key -> DrgFormulaLexer.lex(formula));
    }

    public void setSuppliers(Map<String, NodeSupplier<DrgLexerToken, AstContext>> suppliers) {
        this.suppliers = suppliers;
    }

    private static BooleanExpression<AstContext> createContainsNode(DrgLexerToken token) {
        return new ContainsNode(FormulaEvaluator.createAttribute(token));
    }

    private static BooleanExpression<AstContext> createSuppressionContainsNode(DrgLexerToken token) {
        return new SuppressionContainsNode(FormulaEvaluator.createAttribute(token));
    }

    private static Attribute createAttribute(DrgLexerToken token) {
        String prefix = token.getPrefix().orElse(MsdrgAttributePrefix.NONE.name());
        return new Attribute(MsdrgAttributePrefix.getPrefixFromString(prefix), token.getValue());
    }
}

