/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import gov.agency.msdrg.model.v2.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v400.access.pojo.MsdrgDrgFormula;
import gov.agency.msdrg.v400.logic.FormulaEvaluator;
import gov.agency.msdrg.v400.logic.MsdrgHacProcessor;
import gov.agency.msdrg.v400.logic.MsdrgSeverityProcessor;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgMaskAttributes;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.v400.utility.farser.ast.parser.ExpressionResult;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgFormulaEvaluation
extends FormulaEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgFormulaEvaluation.class);
    private final FormulaDao formulaAccess;

    public MsdrgFormulaEvaluation(FormulaDao dbAccess) {
        this.formulaAccess = dbAccess;
    }

    public EvalContainer evaluateFormulas(List<MsdrgDiagnosisCode> sdxCodes, AstContext context, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        logger.debug("Begin evaluating formulas for mdc: {}", (Object)context.getMdc());
        MsdrgMatchedDrgFormula matchedFormula = new MsdrgMatchedDrgFormula();
        List<MsdrgDrgFormula> databaseRows = this.fetchFormulaRowsByMdc(context.getMdc());
        long start = System.currentTimeMillis();
        MsdrgSeverity severity = MsdrgSeverity.NONE;
        List<MsdrgDiagnosisCode> nonHacCodes = sdxCodes.stream().filter(code -> !MsdrgHacProcessor.isHac(code, hospitalStatus)).collect(Collectors.toList());
        List<Attribute> initialMaskWithoutSeverity = context.getMask();
        for (MsdrgDrgFormula drgFormula : databaseRows) {
            severity = MsdrgSeverityProcessor.processClaimSeverity(nonHacCodes, drgFormula.getSeveritySuppressionOperand());
            MsdrgMaskAttributes maskWithNewSeverity = new MsdrgMaskAttributes();
            maskWithNewSeverity.addAllToMask(initialMaskWithoutSeverity);
            maskWithNewSeverity.addToMask(new Attribute(severity.toString()));
            ExpressionResult<AstContext> evaluation = this.evaluateFormula(context = context.toBuilder().withMask(maskWithNewSeverity.getMask()).build(), drgFormula.getFormula());
            if (!evaluation.isMatched()) continue;
            AstContext evaluationContext = evaluation.getContext();
            matchedFormula = new MsdrgMatchedDrgFormula(drgFormula.getBaseDrg(), drgFormula.getDrg(), drgFormula.getSurgical(), drgFormula.getReRouteMdcId(), drgFormula.getFormula(), evaluation.getContext().getAccumulation(), maskWithNewSeverity, evaluationContext.getGrc());
            break;
        }
        logger.debug("Formula eval took: {} ms", (Object)(System.currentTimeMillis() - start));
        return new EvalContainer(matchedFormula, severity);
    }

    public List<MsdrgDrgFormula> fetchFormulaRowsByMdc(int mdc) {
        return this.formulaAccess.getAllFormulaRowsByMdc(mdc);
    }

    public static class EvalContainer {
        private final MsdrgMatchedDrgFormula matchedDrgFormula;
        private final MsdrgSeverity severity;

        public EvalContainer(MsdrgMatchedDrgFormula matchedDrgFormula, MsdrgSeverity severity) {
            Objects.requireNonNull(matchedDrgFormula, "Formula cannot be null");
            Objects.requireNonNull(severity, "Severity cannot be null");
            this.matchedDrgFormula = matchedDrgFormula;
            this.severity = severity;
        }

        public MsdrgMatchedDrgFormula getMatchedDrgFormula() {
            return this.matchedDrgFormula;
        }

        public MsdrgSeverity getSeverity() {
            return this.severity;
        }
    }
}

