/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import gov.agency.msdrg.model.v2.MsdrgGrouperFlags;
import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.enumeration.MsdrgAdmitDxGrouperFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.MsdrgComponent;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MsdrgGrouperFlagsResult {
    public static MsdrgGrouperFlags createGrouperFlags(ProcessingData processingData, MsdrgHospitalStatusOptionFlag hospitalStatusOptionFlag, MsdrgAffectDrgOptionFlag affectDrgOptionFlag, GroupingContext initialGroupingContext, GroupingContext finalGroupingContext) {
        MsdrgGrouperFlags grouperFlags = new MsdrgGrouperFlags();
        MsdrgDiagnosisCode admitDx = processingData.getAdmitDx();
        grouperFlags.setAdmitDxGrouperFlag(MsdrgGrouperFlagsResult.validateAdmitDx(admitDx));
        grouperFlags.setInitialDrgSecondaryDxCcMcc(MsdrgGrouperFlagsResult.getDrgSeverity(initialGroupingContext));
        grouperFlags.setFinalDrgSecondaryDxCcMcc(MsdrgGrouperFlagsResult.getDrgSeverity(finalGroupingContext));
        int numHacCategoriesSatisfied = MsdrgGrouperFlagsResult.numHacCategoriesSatisfied(processingData.getSdxCodes());
        int initialDrg = processingData.getInitialResult().getDrg();
        int finalDrg = processingData.getFinalResult().getDrg();
        grouperFlags.setNumHacCategoriesSatisfied(numHacCategoriesSatisfied);
        grouperFlags.setHacStatusValue(MsdrgGrouperFlagsResult.hacStatusValue(initialDrg, finalDrg, hospitalStatusOptionFlag, numHacCategoriesSatisfied));
        return grouperFlags;
    }

    private static MsdrgAdmitDxGrouperFlag validateAdmitDx(MsdrgDiagnosisCode admitDx) {
        MsdrgAdmitDxGrouperFlag result = MsdrgAdmitDxGrouperFlag.DX_NOT_GIVEN;
        if (!MsdrgComponent.NULL_CODE_VALUE.equalsIgnoreCase(admitDx.getValue()) && !admitDx.getValue().isEmpty()) {
            if (admitDx.is(MsdrgCode.CodeFlag.VALID)) {
                result = MsdrgAdmitDxGrouperFlag.DX_VALID;
            } else if (!admitDx.is(MsdrgCode.CodeFlag.VALID)) {
                result = MsdrgAdmitDxGrouperFlag.DX_INVALID;
            }
        }
        return result;
    }

    private static MsdrgSeverity getDrgSeverity(GroupingContext matchedDrgFormula) {
        if (matchedDrgFormula != null) {
            for (Attribute attr : matchedDrgFormula.getMatchAttributes()) {
                if (attr.getListName().equals(MsdrgSeverity.MCC.name())) {
                    return MsdrgSeverity.MCC;
                }
                if (!attr.getListName().equals(MsdrgSeverity.CC.name())) continue;
                return MsdrgSeverity.CC;
            }
        }
        return MsdrgSeverity.NON_CC;
    }

    private static int numHacCategoriesSatisfied(List<MsdrgDiagnosisCode> sdxCodes) {
        Set hacsSatisfied = sdxCodes.stream().filter(code -> !code.getHacsFlags().isEmpty()).flatMap(code -> code.getHacsFlags().stream()).filter(hac -> hac.getHacStatus() == MsdrgHacUsage.HAC_CRITERIA_MET).map(MsdrgHac::getHacNumber).collect(Collectors.toSet());
        return hacsSatisfied.size();
    }

    private static MsdrgHacStatus hacStatusValue(int initialDrg, int finalDrg, MsdrgHospitalStatusOptionFlag hospitalStatusPoa, int numHacCategoriesSatisfied) {
        MsdrgHacStatus result = MsdrgHacStatus.NOT_APPLICABLE;
        if (hospitalStatusPoa != MsdrgHospitalStatusOptionFlag.EXEMPT) {
            if (numHacCategoriesSatisfied >= 1 && initialDrg == finalDrg) {
                result = MsdrgHacStatus.FINAL_DRG_NO_CHANGE;
            } else if (numHacCategoriesSatisfied >= 1 && finalDrg == 999) {
                result = MsdrgHacStatus.FINAL_DRG_UNGROUPABLE;
            } else if (numHacCategoriesSatisfied >= 1) {
                result = MsdrgHacStatus.FINAL_DRG_CHANGES;
            }
        }
        return result;
    }
}

