/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgMedSurgType;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;

public class MsdrgGrouperResultReport {
    public MsdrgGrouperResult createGrouperResult(int mdc, GroupingContext groupingContext, MsdrgSeverity severity, DescriptionDao dataAccess) {
        MsdrgGrouperResult.MsdrgGrouperResultBuilder resultBuilder = MsdrgGrouperResult.builder();
        MsdrgMatchedDrgFormula match = groupingContext.getMatch();
        int baseDrg = match.getBaseDrg();
        int drg = match.getDrg();
        resultBuilder.withMdc(mdc);
        resultBuilder.withBaseDrg(baseDrg);
        resultBuilder.withDrg(drg);
        resultBuilder.withSeverity(severity);
        dataAccess.getDrgDescription(drg).ifPresent(resultBuilder::withDrgDescription);
        dataAccess.getBaseDrgDescription(baseDrg).ifPresent(resultBuilder::withBaseDrgDescription);
        dataAccess.getMdcDescription(mdc).ifPresent(resultBuilder::withMdcDescription);
        if (match.getSurgical() != null) {
            if (match.getSurgical().equalsIgnoreCase(MsdrgMedSurgType.SURGICAL.name())) {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.SURGICAL);
            } else if (match.getSurgical().equalsIgnoreCase(MsdrgMedSurgType.MEDICAL.name())) {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.MEDICAL);
            } else {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.NONE);
            }
        } else {
            resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.NONE);
        }
        resultBuilder.withReturnCode(MsdrgGrouperReturnCode.OK);
        if (drg == 998) {
            resultBuilder.withSeverity(MsdrgSeverity.NONE);
        }
        return resultBuilder.build();
    }
}

