/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import com.mmm.his.cer.foundation.model.GfcPoa;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgPoaErrorCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgProcedureHacUsage;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.TraceUtility;
import gov.agency.msdrg.v400.access.blob.dto.HacFormula;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.v400.logic.FormulaEvaluator;
import gov.agency.msdrg.v400.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v400.logic.MsdrgUtility;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgMaskAttributes;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.ast.parser.ExpressionResult;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgHacProcessor
extends FormulaEvaluator
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgHacProcessor.class);
    private static final Set<Integer> HAC_NUMS_PROCS = new HashSet<Integer>(Arrays.asList(8, 10, 11, 12, 13, 14));
    private final DescriptionDao descriptionAccess;
    private final FormulaDao formulaAccess;

    public MsdrgHacProcessor(DescriptionDao descriptionAccess, FormulaDao formulaAccess) {
        this.descriptionAccess = descriptionAccess;
        this.formulaAccess = formulaAccess;
    }

    public static boolean isHac(MsdrgDiagnosisCode code, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        boolean isHac = false;
        for (MsdrgHac hac : code.getHacs()) {
            if (!MsdrgHacUsage.HAC_CRITERIA_MET.equals((Object)hac.getHacStatus()) || hospitalStatus == MsdrgHospitalStatusOptionFlag.EXEMPT) continue;
            isHac = true;
            break;
        }
        return isHac;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        Map<String, NodeSupplier<DrgLexerToken, AstContext>> suppliers = context.getSupplierMap();
        this.setSuppliers(suppliers);
        RuntimeOptions runtimeOptions = context.getRuntime();
        ProcessingData processingData = context.getProcessingData();
        logger.debug("Begin HAC processing (This does not do severity only just seeing if a hac formula is met)");
        if (runtimeOptions.getPoaReportingExempt() != MsdrgHospitalStatusOptionFlag.EXEMPT) {
            processingData = this.processHospitalAcquiredCondition(processingData, processingData.getSdxCodes(), processingData.getProcedureCodes(), runtimeOptions.getPoaReportingExempt(), context.getTraceUtility());
        } else if (runtimeOptions.getPoaReportingExempt() == MsdrgHospitalStatusOptionFlag.EXEMPT) {
            for (MsdrgDiagnosisCode code : processingData.getSdxCodes()) {
                if (code.getHacs().isEmpty()) continue;
                code.setPoaErrorCodeFlag(MsdrgPoaErrorCode.HOSPITAL_EXEMPT);
                for (MsdrgHac hac : code.getHacs()) {
                    hac.setHacStatus(MsdrgHacUsage.HAC_NOT_APPLICABLE_EXEMPT);
                }
            }
            this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
        }
        MsdrgGrouperReturnCode returnCode = null;
        if (processingData.getFinalResult() != null) {
            returnCode = processingData.getFinalResult().getReturnCode();
        }
        if (returnCode != null && returnCode != MsdrgGrouperReturnCode.OK) {
            return new Link.LinkResult(context.toBuilder().withProcessingData(processingData).build(), false);
        }
        context = context.toBuilder().withProcessingData(processingData).build();
        context.getTraceUtility().traceHac(context);
        logger.debug("HAC processing finished");
        return new Link.LinkResult(context, true);
    }

    private ProcessingData processHospitalAcquiredCondition(ProcessingData processingData, List<MsdrgDiagnosisCode> sdxCodes, List<MsdrgProcedureCode> procedureCodes, MsdrgHospitalStatusOptionFlag hospitalStatus, TraceUtility traceUtility) {
        HashMap codesWithHacs = new HashMap();
        String codeOnHac6ButNotShowList = null;
        boolean hasInvalidPoaOnClaim = false;
        for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
            if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
            for (MsdrgHac hac : msdrgDiagnosisCode.getHacs()) {
                if (msdrgDiagnosisCode.getPoa() == GfcPoa.Y || msdrgDiagnosisCode.getPoa() == GfcPoa.W) {
                    hac.setHacStatus(MsdrgHacUsage.HAC_CRITERIA_NOT_MET);
                    msdrgDiagnosisCode.setPoaErrorCodeFlag(this.getPoaErrorCode(msdrgDiagnosisCode.getPoa()));
                    continue;
                }
                if (msdrgDiagnosisCode.is(MsdrgCode.CodeFlag.EXCLUDED)) {
                    hac.setHacStatus(MsdrgHacUsage.HAC_NOT_APPLICABLE_EXCLUSION);
                    msdrgDiagnosisCode.setPoaErrorCodeFlag(this.getPoaErrorCode(msdrgDiagnosisCode.getPoa()));
                    continue;
                }
                MsdrgHacUsage status = this.evaluateHacConditions(processingData, hac, traceUtility);
                hac.setHacStatus(status);
                msdrgDiagnosisCode.setPoaErrorCodeFlag(this.getPoaErrorCode(msdrgDiagnosisCode.getPoa()));
                if (msdrgDiagnosisCode.getPoa() == GfcPoa.E || msdrgDiagnosisCode.getPoa() == GfcPoa.BLANK || msdrgDiagnosisCode.getPoa() == GfcPoa.ONE || msdrgDiagnosisCode.getPoa() == GfcPoa.INVALID) {
                    hasInvalidPoaOnClaim = true;
                }
                if (status != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                if (hac.getHacNumber() == 6 && !msdrgDiagnosisCode.is(MsdrgCode.CodeFlag.ON_SHOW_LIST)) {
                    codeOnHac6ButNotShowList = msdrgDiagnosisCode.getValue();
                }
                List<MsdrgDiagnosisCode> dxCodes = codesWithHacs.containsKey(hac.getHacNumber()) ? (List)codesWithHacs.get(hac.getHacNumber()) : new ArrayList<MsdrgDiagnosisCode>();
                dxCodes.add(msdrgDiagnosisCode);
                codesWithHacs.put(hac.getHacNumber(), dxCodes);
            }
        }
        if (codeOnHac6ButNotShowList == null) {
            for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
                if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
                for (MsdrgHac hac : msdrgDiagnosisCode.getHacs()) {
                    if (!hac.getHacList().equals("hac06_show")) continue;
                    hac.setHacStatus(MsdrgHacUsage.HAC_CRITERIA_NOT_MET);
                }
            }
        }
        for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
            if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
            for (MsdrgHac hac : msdrgDiagnosisCode.getHacs()) {
                if (!HAC_NUMS_PROCS.contains(hac.getHacNumber()) || hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                for (MsdrgProcedureCode procCode : procedureCodes) {
                    int hacNumber = hac.getHacNumber();
                    for (Attribute attr : procCode.getAttributes()) {
                        if (hacNumber < 10) {
                            if (!attr.getListName().contains("hac0" + hacNumber + "_proc")) continue;
                            procCode.getHacUsageFlag().add(MsdrgProcedureHacUsage.fromHacValue(hacNumber));
                            continue;
                        }
                        if (!attr.getListName().contains("hac" + hacNumber + "_proc")) continue;
                        procCode.getHacUsageFlag().add(MsdrgProcedureHacUsage.fromHacValue(hacNumber));
                    }
                }
            }
        }
        boolean markUngroupable = false;
        if (!codesWithHacs.isEmpty() && hospitalStatus == MsdrgHospitalStatusOptionFlag.NON_EXEMPT) {
            Iterator iterator = codesWithHacs.keySet().iterator();
            while (iterator.hasNext()) {
                int hacNumber = (Integer)iterator.next();
                List dxCodes = (List)codesWithHacs.get(hacNumber);
                if (hacNumber == 6) {
                    if (codeOnHac6ButNotShowList == null) continue;
                    for (MsdrgDiagnosisCode dxCode : dxCodes) {
                        if (dxCode.getPoa() != GfcPoa.E && dxCode.getPoa() != GfcPoa.BLANK && dxCode.getPoa() != GfcPoa.ONE && dxCode.getPoa() != GfcPoa.INVALID) continue;
                        markUngroupable = true;
                    }
                    continue;
                }
                for (MsdrgDiagnosisCode dxCode2 : dxCodes) {
                    if (dxCode2.getPoa() != GfcPoa.E && dxCode2.getPoa() != GfcPoa.BLANK && dxCode2.getPoa() != GfcPoa.ONE && dxCode2.getPoa() != GfcPoa.INVALID || !dxCode2.hasHacs()) continue;
                    markUngroupable = true;
                }
                if (!hasInvalidPoaOnClaim) continue;
                markUngroupable = true;
            }
            if (markUngroupable) {
                MsdrgGrouperResult msdrgGrouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_MISSING_ONE_POA, this.descriptionAccess);
                this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                return processingData.toBuilder().withFinalResult(msdrgGrouperResult).build();
            }
        } else if (hospitalStatus == MsdrgHospitalStatusOptionFlag.UNKNOWN && !codesWithHacs.isEmpty()) {
            for (MsdrgDiagnosisCode code : sdxCodes) {
                if (code.getHacs().isEmpty()) continue;
                for (MsdrgHac hac : code.getHacs()) {
                    MsdrgGrouperResult grouperResult;
                    int poaCounter = 0;
                    for (MsdrgDiagnosisCode dxCode : sdxCodes) {
                        if (dxCode.getPoa() == GfcPoa.Y && dxCode.getPoa() == GfcPoa.W) continue;
                        ++poaCounter;
                    }
                    if (poaCounter >= 2) {
                        grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_STATUS_INVALID_MULT_HACS_POA_NOT_Y_W, this.descriptionAccess);
                        code.setSeverityFlag(MsdrgMaskBuildingConditions.NONE);
                        this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                        return processingData.toBuilder().withFinalResult(grouperResult).build();
                    }
                    if (code.getPoa() == GfcPoa.N || code.getPoa() == GfcPoa.U) {
                        grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_N_OR_U, this.descriptionAccess);
                        code.setSeverityFlag(MsdrgMaskBuildingConditions.NONE);
                        this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                        return processingData.toBuilder().withFinalResult(grouperResult).build();
                    }
                    if (code.getPoa() != GfcPoa.INVALID && code.getPoa() != GfcPoa.ONE && code.getPoa() != GfcPoa.BLANK && code.getPoa() != GfcPoa.E) continue;
                    grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_INVALID_OR_1, this.descriptionAccess);
                    code.setSeverityFlag(MsdrgMaskBuildingConditions.NONE);
                    this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
                    return processingData.toBuilder().withFinalResult(grouperResult).build();
                }
            }
        }
        this.updateHacListAfterEvaluation(processingData.getPrincipalDx(), processingData.getSdxCodes());
        return processingData.toBuilder().build();
    }

    private void updateHacListAfterEvaluation(MsdrgDiagnosisCode pdx, List<MsdrgDiagnosisCode> sdxCodes) {
        for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
            MsdrgHac hac;
            boolean containsSix = false;
            boolean criteriaMet = false;
            ArrayList<MsdrgHac> updateHacList = new ArrayList<MsdrgHac>();
            if (msdrgDiagnosisCode.getHacs().isEmpty()) continue;
            Iterator<MsdrgHac> iterator = msdrgDiagnosisCode.getHacs().iterator();
            while (iterator.hasNext()) {
                hac = iterator.next();
                if (hac.getHacStatus() == MsdrgHacUsage.HAC_CRITERIA_MET && (msdrgDiagnosisCode.getPoa() != GfcPoa.W || msdrgDiagnosisCode.getPoa() != GfcPoa.Y)) {
                    if (hac.getHacNumber() == 6 && !containsSix) {
                        updateHacList.add(hac);
                        containsSix = true;
                    } else {
                        if (hac.getHacNumber() == 6 && containsSix) continue;
                        updateHacList.add(hac);
                    }
                    criteriaMet = true;
                    continue;
                }
                if (hac.getHacStatus() == MsdrgHacUsage.HAC_CRITERIA_NOT_MET && (msdrgDiagnosisCode.getPoa() == GfcPoa.W || msdrgDiagnosisCode.getPoa() == GfcPoa.Y)) {
                    hac.setHacNumber(0);
                    updateHacList.add(hac);
                    criteriaMet = true;
                    break;
                }
                if (hac.getHacStatus() == MsdrgHacUsage.HAC_NOT_APPLICABLE_EXCLUSION) {
                    updateHacList.add(hac);
                    criteriaMet = true;
                    continue;
                }
                if (hac.getHacStatus() != MsdrgHacUsage.HAC_NOT_APPLICABLE_EXEMPT) continue;
                hac.setHacNumber(0);
                updateHacList.add(hac);
                criteriaMet = true;
            }
            if (!criteriaMet && (iterator = msdrgDiagnosisCode.getHacs().iterator()).hasNext()) {
                hac = iterator.next();
                hac.setHacNumber(0);
                updateHacList.add(hac);
            }
            msdrgDiagnosisCode.setHacsFlags(updateHacList);
        }
        boolean hac11present = false;
        if (!pdx.getHacs().isEmpty()) {
            block2: for (MsdrgDiagnosisCode dxCode : sdxCodes) {
                if (dxCode.getHacsFlags().isEmpty()) continue;
                for (MsdrgHac hac : dxCode.getHacsFlags()) {
                    if (hac.getHacNumber() != 11 || hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                    hac11present = true;
                    continue block2;
                }
            }
        }
        if (hac11present) {
            MsdrgHac msdrgHac = new MsdrgHac();
            msdrgHac.setHacNumber(11);
            this.descriptionAccess.getHacDescription(11).ifPresent(msdrgHac::setDescription);
            pdx.setHacsFlags(Collections.singletonList(msdrgHac));
        }
    }

    private MsdrgPoaErrorCode getPoaErrorCode(GfcPoa poa) {
        if (poa == GfcPoa.Y || poa == GfcPoa.W) {
            return MsdrgPoaErrorCode.POA_RECOGNIZED_YES_POA;
        }
        if (poa == GfcPoa.N || poa == GfcPoa.U) {
            return MsdrgPoaErrorCode.POA_RECOGNIZED_NOT_POA;
        }
        if (poa == GfcPoa.INVALID || poa == GfcPoa.BLANK || poa == GfcPoa.E || poa == GfcPoa.ONE) {
            return MsdrgPoaErrorCode.POA_NOT_RECOGNIZED;
        }
        return MsdrgPoaErrorCode.POA_NOT_RECOGNIZED;
    }

    public MsdrgHacUsage evaluateHacConditions(ProcessingData processingData, MsdrgHac hac, TraceUtility traceUtility) {
        MsdrgHacUsage hacStatus = MsdrgHacUsage.HAC_CRITERIA_NOT_MET;
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        AstContext context = AstContext.builder().withMask(mask.getMask()).withProcedureCodes(processingData.getProcedureCodes()).withDiagnosisCodes(processingData.getSdxCodes()).build();
        List<HacFormula> hacRows = this.formulaAccess.getFormulasForHacList(hac.getHacNumber());
        if (!hacRows.isEmpty()) {
            for (HacFormula hacFormula : hacRows) {
                ExpressionResult<AstContext> evaluation = this.evaluateFormulaWithoutSuppression(context, hacFormula.getFormula());
                if (!evaluation.isMatched()) continue;
                hacStatus = MsdrgHacUsage.HAC_CRITERIA_MET;
                traceUtility.traceHacFormula(hacFormula);
                break;
            }
        }
        return hacStatus;
    }
}

