/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MsdrgSeverityProcessor {
    private MsdrgSeverityProcessor() {
    }

    public static MsdrgSeverity processClaimSeverity(List<MsdrgDiagnosisCode> diagnosisCodes, Set<String> severitySuppressionOperands) {
        ArrayList<MsdrgDiagnosisCode> nonSuppressedOrExcluded = new ArrayList<MsdrgDiagnosisCode>();
        for (MsdrgDiagnosisCode dxCode : diagnosisCodes) {
            dxCode.unMark(MsdrgCode.CodeFlag.DOWNGRADE_SEVERITY_SUPPRESSION);
            for (String severitySuppressionOperand : severitySuppressionOperands) {
                if (!dxCode.hasAttribute(severitySuppressionOperand)) continue;
                dxCode.mark(MsdrgCode.CodeFlag.DOWNGRADE_SEVERITY_SUPPRESSION);
                break;
            }
            if (dxCode.is(MsdrgCode.CodeFlag.DOWNGRADE_SEVERITY_SUPPRESSION) || dxCode.is(MsdrgCode.CodeFlag.EXCLUDED) || dxCode.is(MsdrgCode.CodeFlag.DEATH_EXCLUSION)) continue;
            nonSuppressedOrExcluded.add(dxCode);
        }
        return MsdrgSeverityProcessor.getHighestSeverity(nonSuppressedOrExcluded);
    }

    private static MsdrgSeverity getHighestSeverity(List<MsdrgDiagnosisCode> sdxCodes) {
        return sdxCodes.stream().map(MsdrgDiagnosisCode::getSeverity).reduce(MsdrgSeverity.NON_CC, (sev, currSev) -> sev.getSeverityLevel() > currSev.getSeverityLevel() ? currSev : sev);
    }
}

