/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.ast;

import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AstContext {
    private final List<MsdrgDiagnosisCode> diagnosisCodes;
    private final List<MsdrgProcedureCode> procedureCodes;
    private final List<Attribute> mask;
    private final Set<Attribute> accumulator;
    private final int mdc;
    private int grc;

    private AstContext(List<MsdrgDiagnosisCode> diagnosisCodes, List<MsdrgProcedureCode> procedureCodes, List<Attribute> mask, int mdc) {
        this.diagnosisCodes = diagnosisCodes == null ? Collections.emptyList() : new ArrayList<MsdrgDiagnosisCode>(diagnosisCodes);
        this.procedureCodes = procedureCodes == null ? Collections.emptyList() : new ArrayList<MsdrgProcedureCode>(procedureCodes);
        this.mask = new ArrayList<Attribute>(mask);
        this.mdc = mdc;
        this.accumulator = new HashSet<Attribute>();
    }

    public static AstContextBuilder builder() {
        return new AstContextBuilder();
    }

    public void accumulate(Attribute attribute) {
        Attribute copy = new Attribute(attribute.getPrefix(), attribute.getNegated(), attribute.getListName());
        copy.setMdcSuppression(attribute.getMdcSuppression());
        this.accumulator.add(copy);
    }

    public void accumulate(Set<Attribute> attributes) {
        attributes.forEach(this::accumulate);
    }

    public Set<Attribute> getAccumulation() {
        return new HashSet<Attribute>(this.accumulator);
    }

    public List<MsdrgDiagnosisCode> getDiagnosisCodes() {
        return new ArrayList<MsdrgDiagnosisCode>(this.diagnosisCodes);
    }

    public List<MsdrgProcedureCode> getProcedureCodes() {
        return new ArrayList<MsdrgProcedureCode>(this.procedureCodes);
    }

    public List<Attribute> getMask() {
        return new ArrayList<Attribute>(this.mask);
    }

    public int getMdc() {
        return this.mdc;
    }

    public int getGrc() {
        return this.grc;
    }

    public void setGrc(int grc) {
        this.grc = grc;
    }

    public AstContextBuilder toBuilder() {
        return new AstContextBuilder(this);
    }

    public static final class AstContextBuilder {
        private List<MsdrgDiagnosisCode> diagnosisCodes;
        private List<MsdrgProcedureCode> procedureCodes;
        private List<Attribute> mask;
        private int mdc;

        private AstContextBuilder() {
        }

        private AstContextBuilder(AstContext objectToCopy) {
            this.diagnosisCodes = objectToCopy.diagnosisCodes;
            this.procedureCodes = objectToCopy.procedureCodes;
            this.mask = objectToCopy.mask;
            this.mdc = objectToCopy.mdc;
        }

        public AstContextBuilder withDiagnosisCodes(List<MsdrgDiagnosisCode> diagnosisCodes) {
            this.diagnosisCodes = diagnosisCodes;
            return this;
        }

        public AstContextBuilder withProcedureCodes(List<MsdrgProcedureCode> procedureCodes) {
            this.procedureCodes = procedureCodes;
            return this;
        }

        public AstContextBuilder withMask(List<Attribute> mask) {
            this.mask = mask;
            return this;
        }

        public AstContextBuilder withMdc(int mdc) {
            this.mdc = mdc;
            return this;
        }

        public AstContext build() {
            return new AstContext(this.diagnosisCodes, this.procedureCodes, this.mask, this.mdc);
        }
    }
}

