/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.ast;

import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.ast.AttributeEnum;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.BooleanExpression;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class BilateralNode
implements BooleanExpression<AstContext> {
    @Override
    public boolean evaluate(AstContext context) {
        List<MsdrgProcedureCode> orderedCodes = context.getProcedureCodes();
        HashSet<MsdrgProcedureCode> codesToMark = new HashSet<MsdrgProcedureCode>();
        HashSet<Attribute> bilateralsFound = new HashSet<Attribute>();
        for (MsdrgProcedureCode code2 : orderedCodes) {
            if (bilateralsFound.size() == 2) break;
            Optional<Attribute> maybeAttribute = this.checkAttributes(code2, bilateralsFound);
            if (!maybeAttribute.isPresent()) continue;
            codesToMark.add(code2);
            bilateralsFound.add(maybeAttribute.get());
        }
        if (bilateralsFound.size() == 2) {
            context.accumulate(bilateralsFound);
            codesToMark.forEach(code -> code.mark(MsdrgCode.CodeFlag.BILATERAL));
        }
        return bilateralsFound.size() == 2;
    }

    private Optional<Attribute> checkAttributes(MsdrgProcedureCode code, Set<Attribute> foundAttrs) {
        for (Bilateral value : Bilateral.values()) {
            Attribute attribute = value.getAttribute();
            if (!code.hasAttribute(attribute) || foundAttrs.contains(attribute)) continue;
            return Optional.of(attribute);
        }
        return Optional.empty();
    }

    private static enum Bilateral implements AttributeEnum
    {
        RIGHT_HIP(new Attribute("righthip")),
        RIGHT_KNEE(new Attribute("rightknee")),
        RIGHT_ANKLE(new Attribute("rightankle")),
        LEFT_HIP(new Attribute("lefthip")),
        LEFT_KNEE(new Attribute("leftknee")),
        LEFT_ANKLE(new Attribute("leftankle"));

        private final Attribute attribute;

        private Bilateral(Attribute attribute) {
            this.attribute = attribute;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }
    }
}

