/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.ast;

import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.ast.AttributeEnum;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.BooleanExpression;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;

public class CountFourNode
implements BooleanExpression<AstContext> {
    private final Attribute attribute;
    private final MsdrgCode.CodeFlag flag;
    private final Class<? extends AttributeEnum> countEnum;
    private BiFunction<MsdrgProcedureCode, Attribute, Boolean> attrCheck = MsdrgProcedureCode::hasAttribute;

    public CountFourNode(Attribute attribute, Class<? extends AttributeEnum> countEnum, MsdrgCode.CodeFlag flag) {
        this.attribute = attribute;
        this.flag = flag;
        if (attribute == null) {
            this.attrCheck = (code, attr) -> true;
        }
        this.countEnum = countEnum;
    }

    @Override
    public boolean evaluate(AstContext context) {
        List<MsdrgProcedureCode> orderedCodes = context.getProcedureCodes();
        HashSet<MsdrgProcedureCode> codesToMark = new HashSet<MsdrgProcedureCode>();
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        int count = 0;
        for (MsdrgProcedureCode code2 : orderedCodes) {
            if (count >= 4) break;
            for (AttributeEnum value : this.countEnum.getEnumConstants()) {
                if (!code2.hasAttribute(value.getAttribute()) || !this.attrCheck.apply(code2, this.attribute).booleanValue()) continue;
                attributes.add(value.getAttribute());
                codesToMark.add(code2);
                count += value.getCount();
            }
        }
        if (count >= 4) {
            context.accumulate(attributes);
            codesToMark.forEach(code -> code.mark(this.flag));
            return true;
        }
        return false;
    }
}

