/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v400.logic.MsdrgUtility;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.commonprocess.GroupingExecutor;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.Map;

public abstract class MdcRerouteGrouping
implements Link,
GroupingExecutor {
    protected final DescriptionDao descriptionAccess;
    protected final FormulaDao formulaAccess;

    public MdcRerouteGrouping(FormulaDao formulaAccess, DescriptionDao descriptionAccess) {
        this.formulaAccess = formulaAccess;
        this.descriptionAccess = descriptionAccess;
    }

    protected abstract GroupingContext fetchGroupingContext(ProcessingContext var1);

    protected abstract ProcessingContext buildNewProcessingContext(MsdrgMatchedDrgFormula var1, MsdrgMatchedDrgFormula var2, ProcessingContext var3);

    protected abstract ProcessingData addSeverityToProcessingData(ProcessingData var1, MsdrgSeverity var2);

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgGrouperReturnCode grouperReturnCode;
        MsdrgMatchedDrgFormula newMatchedFormula;
        RuntimeOptions runtimeOptions;
        GroupingContext groupingContext = this.fetchGroupingContext(context);
        if (!groupingContext.needReroute()) {
            return new Link.LinkResult(context, true);
        }
        MsdrgMatchedDrgFormula previousStateMatch = groupingContext.getPreviousStateMatch();
        Map<String, NodeSupplier<DrgLexerToken, AstContext>> suppliers = context.getSupplierMap();
        ProcessingData processingData = context.getProcessingData();
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.group(processingData, suppliers, (runtimeOptions = context.getRuntime()).getPoaReportingExempt(), previousStateMatch.getReRouteMdcId(), this.formulaAccess, context.getTraceUtility());
        if (evalContainer != null) {
            newMatchedFormula = evalContainer.getMatchedDrgFormula();
            grouperReturnCode = newMatchedFormula.getGrouperReturnCode();
            if (grouperReturnCode != MsdrgGrouperReturnCode.OK) {
                MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(grouperReturnCode, this.descriptionAccess);
                context = context.toBuilder().withProcessingData(processingData.toBuilder().withFinalResult(grouperResult).withInitialResult(grouperResult).build()).build();
                return new Link.LinkResult(context, false);
            }
        } else {
            throw new FoundationException("Formula evaluation failed.");
        }
        if (newMatchedFormula.getReRouteMdcId() != 0) {
            evalContainer = this.group(processingData, suppliers, runtimeOptions.getPoaReportingExempt(), newMatchedFormula.getReRouteMdcId(), this.formulaAccess, context.getTraceUtility());
            if (evalContainer != null) {
                newMatchedFormula = evalContainer.getMatchedDrgFormula();
                grouperReturnCode = newMatchedFormula.getGrouperReturnCode();
                if (grouperReturnCode != MsdrgGrouperReturnCode.OK) {
                    MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(grouperReturnCode, this.descriptionAccess);
                    context = context.toBuilder().withProcessingData(processingData.toBuilder().withFinalResult(grouperResult).withInitialResult(grouperResult).build()).build();
                    return new Link.LinkResult(context, false);
                }
            } else {
                throw new FoundationException("Formula evaluation failed.");
            }
        }
        context = this.buildNewProcessingContext(previousStateMatch, newMatchedFormula, context);
        processingData = this.addSeverityToProcessingData(processingData, evalContainer.getSeverity());
        context = context.toBuilder().withProcessingData(processingData).build();
        return new Link.LinkResult(context, true);
    }
}

