/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.MsdrgGrouperResultReport;
import java.util.LinkedList;

public abstract class MsdrgDrgResults
implements Link {
    private final DescriptionDao descriptionDao;

    protected MsdrgDrgResults(DescriptionDao descriptionDao) {
        this.descriptionDao = descriptionDao;
    }

    protected abstract LinkedList<Integer> fetchMdcs(ProcessingContext var1);

    protected abstract ProcessingData addResultsToProcessingData(ProcessingData var1, MsdrgGrouperResult var2);

    protected abstract GroupingContext fetchGroupingContext(ProcessingContext var1);

    protected abstract MsdrgSeverity fetchSeverity(ProcessingData var1);

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgGrouperResult result;
        ProcessingData processingData = context.getProcessingData();
        GroupingContext groupingContext = this.fetchGroupingContext(context);
        LinkedList<Integer> allMdcStops = this.fetchMdcs(context);
        MsdrgGrouperResultReport report = new MsdrgGrouperResultReport();
        MsdrgSeverity severity = this.fetchSeverity(processingData);
        if (groupingContext.getMatchDrg() == 999) {
            result = report.createGrouperResult(0, groupingContext, severity, this.descriptionDao);
        } else {
            int mdc = processingData.getPrincipalDx().getMdc();
            if (!allMdcStops.isEmpty() && allMdcStops.getLast() == 29) {
                mdc = allMdcStops.contains(24) ? 24 : (allMdcStops.contains(25) ? 25 : allMdcStops.get(allMdcStops.size() - 2));
            } else if (allMdcStops.getLast() != 0) {
                mdc = allMdcStops.getLast();
            }
            result = report.createGrouperResult(mdc, groupingContext, severity, this.descriptionDao);
        }
        context = context.toBuilder().withProcessingData(this.addResultsToProcessingData(processingData, result)).build();
        return new Link.LinkResult(context, true);
    }
}

