/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.initialprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.commonprocess.MsdrgDrgResults;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgInitialDrgResults
extends MsdrgDrgResults
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgInitialDrgResults.class);

    public MsdrgInitialDrgResults(DescriptionDao descriptionDao) {
        super(descriptionDao);
    }

    @Override
    protected LinkedList<Integer> fetchMdcs(ProcessingContext context) {
        return context.getInitialMdc();
    }

    @Override
    protected ProcessingData addResultsToProcessingData(ProcessingData processingData, MsdrgGrouperResult result) {
        return processingData.toBuilder().withInitialResult(result).build();
    }

    @Override
    protected GroupingContext fetchGroupingContext(ProcessingContext context) {
        return context.getInitialGroupingContext();
    }

    @Override
    protected MsdrgSeverity fetchSeverity(ProcessingData processingData) {
        return processingData.getInitialSeverity();
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        Link.LinkResult linkResult = super.execute(context);
        MsdrgGrouperResult grouperResult = linkResult.getContext().getProcessingData().getInitialResult();
        context.getTraceUtility().traceGrouperResults(MsdrgGroupingImpact.INITIAL, grouperResult);
        return linkResult;
    }
}

