/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.marking;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.logic.marking.Marking;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.util.List;
import java.util.TreeSet;

public abstract class DiagnosisMarking
extends Marking
implements Link {
    public static final Attribute INCIDENT_ATTR = new Attribute(MsdrgAttributePrefix.ONLY, "incident");

    abstract boolean isMarked(MsdrgDiagnosisCode var1);

    abstract void setMarked(MsdrgDiagnosisCode var1);

    abstract void setDrgImpact(MsdrgDiagnosisCode var1);

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        if (context.getRuntime().getComputeAffectDrg() != MsdrgAffectDrgOptionFlag.COMPUTE) {
            return new Link.LinkResult(context, true);
        }
        ProcessingData processingData = context.getProcessingData();
        List<MsdrgDiagnosisCode> sdxCodes = processingData.getSdxCodes();
        MsdrgDiagnosisCode principalDx = processingData.getPrincipalDx();
        GroupingContext groupingContext = this.fetchGroupingContext(context);
        TreeSet<Attribute> matchedAttributes = new TreeSet<Attribute>(groupingContext.getMatchAttributes());
        TreeSet<Attribute> attrToRemove = new TreeSet<Attribute>();
        for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
            for (Attribute attribute : matchedAttributes) {
                if (this.isMarked(sdxCode) && sdxCode.getAttributeMarkedFor() == attribute) {
                    attrToRemove.add(attribute);
                    break;
                }
                if (attribute.equals(INCIDENT_ATTR) || principalDx.hasAttribute(attribute.getListName()) && (attribute.getPrefix().equals((Object)MsdrgAttributePrefix.PDX) || attribute.getPrefix().equals((Object)MsdrgAttributePrefix.ANY))) continue;
                if ((attribute.getListName().equalsIgnoreCase("MCC") || attribute.getListName().equalsIgnoreCase("CC")) && !sdxCode.is(MsdrgCode.CodeFlag.DOWNGRADE_SEVERITY_SUPPRESSION) && !sdxCode.is(MsdrgCode.CodeFlag.EXCLUDED) && !sdxCode.is(MsdrgCode.CodeFlag.DEATH_EXCLUSION) && sdxCode.getSeverity().toString().equalsIgnoreCase(attribute.getListName())) {
                    this.setMarked(sdxCode);
                    this.setDrgImpact(sdxCode);
                    sdxCode.setAttributeMarkedFor(attribute);
                    attrToRemove.add(attribute);
                    break;
                }
                if (attribute.getPrefix() != MsdrgAttributePrefix.SDX && attribute.getPrefix() != MsdrgAttributePrefix.ANY || !sdxCode.hasAttribute(attribute.getListName())) continue;
                this.setMarked(sdxCode);
                this.setDrgImpact(sdxCode);
                sdxCode.setAttributeMarkedFor(attribute);
                attrToRemove.add(attribute);
                break;
            }
            matchedAttributes.removeAll(attrToRemove);
        }
        GroupingContext initialGroupingContext = context.getInitialGroupingContext();
        if (groupingContext.differentDrgs(initialGroupingContext)) {
            for (MsdrgDiagnosisCode dxCode : sdxCodes) {
                if (!dxCode.hasHacs()) continue;
                this.setMarked(dxCode);
                this.setDrgImpact(dxCode);
            }
        }
        processingData = processingData.toBuilder().withSdxCodes(sdxCodes).withPdx(principalDx).build();
        context = context.toBuilder().withProcessingData(processingData).build();
        return new Link.LinkResult(context, true);
    }
}

