/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.marking;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.v400.logic.MsdrgHacProcessor;
import gov.agency.msdrg.v400.logic.marking.DiagnosisMarking;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.util.ArrayList;
import java.util.List;

public class FinalDiagnosisMarking
extends DiagnosisMarking
implements Link {
    @Override
    GroupingContext fetchGroupingContext(ProcessingContext context) {
        return context.getFinalGroupingContext();
    }

    @Override
    boolean isMarked(MsdrgDiagnosisCode code) {
        return code.is(MsdrgCode.CodeFlag.MARKED_FOR_FINAL);
    }

    @Override
    void setMarked(MsdrgDiagnosisCode code) {
        code.mark(MsdrgCode.CodeFlag.MARKED_FOR_FINAL);
    }

    @Override
    void setDrgImpact(MsdrgDiagnosisCode code) {
        code.setDrgImpact(this.impactMarking(code.getDrgImpact()));
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        context = super.execute(context).getContext();
        ProcessingData processingData = context.getProcessingData();
        MsdrgDiagnosisCode principalDx = processingData.getPrincipalDx();
        MsdrgGrouperResult finalResult = processingData.getFinalResult();
        MsdrgGrouperReturnCode returnCode = null;
        if (finalResult != null) {
            returnCode = finalResult.getReturnCode();
        }
        if (context.getRuntime().getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE && returnCode != MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS && returnCode != MsdrgGrouperReturnCode.HAC_MISSING_ONE_POA && returnCode != MsdrgGrouperReturnCode.HAC_STATUS_INVALID_MULT_HACS_POA_NOT_Y_W && returnCode != MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_INVALID_OR_1 && returnCode != MsdrgGrouperReturnCode.HAC_STATUS_INVALID_POA_N_OR_U) {
            this.principalDxMarkingLogic(principalDx);
        }
        MsdrgHospitalStatusOptionFlag hospitalStatusFlag = context.getRuntime().getPoaReportingExempt();
        List<MsdrgDiagnosisCode> sdxCodes = processingData.getSdxCodes();
        sdxCodes = this.markSeverityFlag(sdxCodes, hospitalStatusFlag);
        processingData = processingData.toBuilder().withSdxCodes(sdxCodes).build();
        context = context.toBuilder().withProcessingData(processingData).build();
        return new Link.LinkResult(context, true);
    }

    private void principalDxMarkingLogic(MsdrgDiagnosisCode pdx) {
        pdx.setDrgImpact(MsdrgGroupingImpact.BOTH);
        pdx.mark(MsdrgCode.CodeFlag.MARKED_FOR_INITIAL, MsdrgCode.CodeFlag.MARKED_FOR_FINAL);
    }

    private List<MsdrgDiagnosisCode> markSeverityFlag(List<MsdrgDiagnosisCode> sdxCodes, MsdrgHospitalStatusOptionFlag hospitalStatusFlag) {
        ArrayList<MsdrgDiagnosisCode> markedCodes = new ArrayList<MsdrgDiagnosisCode>();
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            boolean excluded = dxCode.is(MsdrgCode.CodeFlag.EXCLUDED);
            boolean deathExcluded = dxCode.is(MsdrgCode.CodeFlag.DEATH_EXCLUSION);
            if (dxCode.getSeverity() != MsdrgSeverity.NON_CC && !excluded && !deathExcluded && MsdrgHacProcessor.isHac(dxCode, hospitalStatusFlag)) {
                dxCode.markSeverityFlag(MsdrgMaskBuildingConditions.FINAL);
            } else if (excluded && !deathExcluded) {
                dxCode.markSeverityFlag(MsdrgMaskBuildingConditions.FINAL);
            } else if (!excluded && !deathExcluded && dxCode.getSeverity() != MsdrgSeverity.NON_CC) {
                dxCode.markSeverityFlag(MsdrgMaskBuildingConditions.FINAL);
            }
            if ((excluded || deathExcluded) && dxCode.getSeverity() != MsdrgSeverity.NON_CC) {
                dxCode.markSeverityFlag(MsdrgMaskBuildingConditions.FINAL);
            }
            markedCodes.add(dxCode);
        }
        return markedCodes;
    }
}

