/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.marking;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.v400.logic.marking.DiagnosisMarking;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.util.ArrayList;
import java.util.List;

public class InitialDiagnosisMarking
extends DiagnosisMarking
implements Link {
    @Override
    GroupingContext fetchGroupingContext(ProcessingContext context) {
        return context.getInitialGroupingContext();
    }

    @Override
    boolean isMarked(MsdrgDiagnosisCode code) {
        return code.is(MsdrgCode.CodeFlag.MARKED_FOR_INITIAL);
    }

    @Override
    void setMarked(MsdrgDiagnosisCode code) {
        code.mark(MsdrgCode.CodeFlag.MARKED_FOR_INITIAL);
    }

    @Override
    void setDrgImpact(MsdrgDiagnosisCode code) {
        code.setDrgImpact(MsdrgGroupingImpact.INITIAL);
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        context = super.execute(context).getContext();
        ProcessingData processingData = context.getProcessingData();
        MsdrgDiagnosisCode principalDx = processingData.getPrincipalDx();
        MsdrgGrouperResult initialResult = processingData.getInitialResult();
        MsdrgGrouperReturnCode returnCode = null;
        if (initialResult != null) {
            returnCode = initialResult.getReturnCode();
        }
        if (context.getRuntime().getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE && (returnCode == null || returnCode != MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS && returnCode != MsdrgGrouperReturnCode.DX_CANNOT_BE_PDX && initialResult.getReturnCode() != MsdrgGrouperReturnCode.INVALID_PDX && initialResult.getReturnCode() != MsdrgGrouperReturnCode.INVALID_SEX)) {
            principalDx.setDrgImpact(MsdrgGroupingImpact.INITIAL);
        }
        List<MsdrgDiagnosisCode> sdxCodes = processingData.getSdxCodes();
        sdxCodes = this.markSeverityFlag(sdxCodes);
        processingData = processingData.toBuilder().withSdxCodes(sdxCodes).build();
        context = context.toBuilder().withProcessingData(processingData).build();
        return new Link.LinkResult(context, true);
    }

    private List<MsdrgDiagnosisCode> markSeverityFlag(List<MsdrgDiagnosisCode> sdxCodes) {
        ArrayList<MsdrgDiagnosisCode> markedCodes = new ArrayList<MsdrgDiagnosisCode>();
        for (MsdrgDiagnosisCode sdxCode : sdxCodes) {
            boolean excluded = sdxCode.is(MsdrgCode.CodeFlag.EXCLUDED);
            boolean deathExcluded = sdxCode.is(MsdrgCode.CodeFlag.DEATH_EXCLUSION);
            if (!excluded && !deathExcluded) {
                sdxCode.markSeverityFlag(MsdrgMaskBuildingConditions.INITIAL);
            }
            if ((excluded || deathExcluded) && sdxCode.getSeverity() != MsdrgSeverity.NON_CC) {
                sdxCode.markSeverityFlag(MsdrgMaskBuildingConditions.INITIAL);
            }
            markedCodes.add(sdxCode);
        }
        return markedCodes;
    }
}

