/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.preprocess;

import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.Dao;
import gov.agency.msdrg.v400.access.pojo.MsdrgClusterDefinition;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.model.ClusterChoices;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgClusters
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgClusters.class);
    private final Dao<List<String>, Set<MsdrgClusterDefinition>> clusterAccess;

    public MsdrgClusters(Dao<List<String>, Set<MsdrgClusterDefinition>> access) {
        this.clusterAccess = access;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        ProcessingData processingData = context.getProcessingData();
        ProcessingContext.ProcessingContextBuilder contextBuilder = context.toBuilder();
        if (!processingData.getProcedureCodes().isEmpty()) {
            logger.debug("Begin processing of clusters");
            try {
                List<MsdrgProcedureCode> procClusters = this.processClusters(processingData, this.clusterAccess);
                procClusters.sort(Comparator.comparing(MsdrgCode::getValue));
                ProcessingData updatedProcessingData = processingData.toBuilder().withClusters(procClusters).build();
                contextBuilder.withProcessingData(updatedProcessingData);
                context.getTraceUtility().traceClustersCodes(procClusters);
            }
            catch (IOException | SQLException exception) {
                exception.printStackTrace();
            }
            logger.debug("Clusters finished");
        }
        return new Link.LinkResult(contextBuilder.build(), true);
    }

    private List<MsdrgProcedureCode> processClusters(ProcessingData data, Dao<List<String>, Set<MsdrgClusterDefinition>> clusterAccess) throws SQLException, IOException {
        ArrayList<MsdrgProcedureCode> procClusters = new ArrayList<MsdrgProcedureCode>();
        logger.debug("Cluster ids retrieved from database");
        Set<MsdrgClusterDefinition> clusters = clusterAccess.getData(data.getProcedureCodes().stream().filter(Objects::nonNull).map(MsdrgProcedureCode::getValue).collect(Collectors.toList()));
        block0: for (MsdrgClusterDefinition cluster : clusters) {
            ClusterChoices choices = cluster.getChoices();
            int choiceCount = choices.getChoiceCount();
            BitSet choiceTracker = new BitSet(choiceCount);
            HashSet<String> chosen = new HashSet<String>();
            for (MsdrgProcedureCode procedureCode : data.getProcedureCodes()) {
                Optional<Integer> contains = choices.contains(procedureCode.getValue());
                if (contains.isPresent()) {
                    int choiceNumber = contains.get() - 1;
                    choiceTracker.set(choiceNumber);
                    chosen.add(procedureCode.getValue());
                }
                if (choiceTracker.nextClearBit(0) < choiceCount) continue;
                MsdrgProcedureCode clusterCode = new MsdrgProcedureCode(new MsdrgInputPrCode(cluster.getClusterCode()));
                clusterCode.setMdcSuppression(cluster.getMdcRestrictions());
                procClusters.add(clusterCode);
                for (MsdrgProcedureCode msdrgProcedureCode : data.getProcedureCodes()) {
                    if (!chosen.contains(msdrgProcedureCode.getValue())) continue;
                    msdrgProcedureCode.setMdcSuppression(cluster.getMdcRestrictions());
                    msdrgProcedureCode.getClusterIds().add(cluster.getClusterCode());
                }
                continue block0;
            }
        }
        return procClusters;
    }
}

