/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.preprocess;

import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.ProcedureDao;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureAttributeProcessor
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(ProcedureAttributeProcessor.class);
    private static final String D477 = "d477";
    private static final String D468 = "d468";
    private final ProcedureDao procedureDao;

    public ProcedureAttributeProcessor(ProcedureDao procedureDao) {
        this.procedureDao = procedureDao;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        ProcessingData processingData = context.getProcessingData();
        logger.debug("Begin processing of attributes");
        ArrayList<MsdrgProcedureCode> processingProcCodes = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
        for (MsdrgProcedureCode msdrgProcedureCode : processingProcCodes) {
            msdrgProcedureCode.setAttributes(this.getProcedureAttributes(msdrgProcedureCode));
            Optional<Attribute> maybeAttribute = this.addOperatingRoomProcedure(msdrgProcedureCode);
            if (maybeAttribute.isPresent()) {
                Attribute attribute = maybeAttribute.get();
                attribute.setMdcSuppression(msdrgProcedureCode.getMdcSuppression());
                msdrgProcedureCode.getAttributes().add(attribute);
            }
            msdrgProcedureCode.setValidCode(!msdrgProcedureCode.getAttributes().isEmpty());
        }
        ArrayList<MsdrgProcedureCode> processingDataClusters = new ArrayList<MsdrgProcedureCode>(processingData.getClusters());
        for (MsdrgProcedureCode clusterCode : processingDataClusters) {
            clusterCode.setAttributes(this.getClusterAttributes(clusterCode));
            Optional<Attribute> maybeAttribute = this.addOperatingRoomProcedure(clusterCode);
            maybeAttribute.ifPresent(clusterCode.getAttributes()::add);
        }
        ProcessingData processingData2 = processingData.toBuilder().withClusters(processingDataClusters).withProcedures(processingProcCodes).build();
        context = context.toBuilder().withProcessingData(processingData2).build();
        context.getTraceUtility().traceProcedureCodes(processingProcCodes);
        return new Link.LinkResult(context, true);
    }

    private Set<Attribute> getProcedureAttributes(MsdrgProcedureCode procCode) {
        Set<Attribute> attributes = this.procedureDao.getAttributesForProcedure(procCode.getValue());
        attributes.forEach(attribute -> attribute.setMdcSuppression(procCode.getMdcSuppression()));
        return attributes;
    }

    private Set<Attribute> getClusterAttributes(MsdrgProcedureCode clusterCode) {
        return this.procedureDao.getAttributesForProcedure(clusterCode.getValue());
    }

    private Optional<Attribute> addOperatingRoomProcedure(MsdrgProcedureCode code) {
        Optional<Attribute> attr = Optional.empty();
        if (code.hasAttribute(new Attribute(D477)) || code.hasAttribute(new Attribute(D468))) {
            attr = Optional.of(new Attribute(MsdrgAttributePrefix.NONE, false, MsdrgSourceLogicLists.ORPROC.getValue()));
        }
        return attr;
    }
}

