/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.preprocess;

import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DiagnosisDao;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.logic.DiagnosisAttributeProcessor;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdxAttributeProcessor
extends DiagnosisAttributeProcessor
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(SdxAttributeProcessor.class);
    private static final String HAC_6_SHOW = "hac06_show";

    public SdxAttributeProcessor(DiagnosisDao diagnosisAccess) {
        super(diagnosisAccess);
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        logger.debug("Begin processing of attributes");
        RuntimeOptions runtimeOption = context.getRuntime();
        ProcessingData processingData = context.getProcessingData();
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            if (!this.diagnosisAccess.isCodeValid(dxCode.getValue())) continue;
            dxCode.mark(MsdrgCode.CodeFlag.VALID);
        }
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            try {
                dxCode.setSeverity(this.getDiagnosisSeverity(dxCode));
            }
            catch (IOException | SQLException exception) {
                exception.printStackTrace();
            }
            Set<Attribute> attributes = this.getSdxAttributes(dxCode);
            dxCode.setAttributes(attributes);
            Set<Attribute> dxCatAttributes = this.getSdxDxCatAttributes(dxCode);
            dxCode.setDxCatAttributes(dxCatAttributes);
            Set<Attribute> dxHacAttributes = this.getSdxHacAttributes(dxCode);
            dxCode.setHacAttributes(dxHacAttributes);
            if (!dxHacAttributes.isEmpty()) {
                for (Attribute attr : dxHacAttributes) {
                    if (!attr.getListName().startsWith("HAC")) continue;
                    dxCode.setHacs(this.getDiagnosisHac(dxCode));
                }
            }
            if (dxHacAttributes.contains(new Attribute(MsdrgAttributePrefix.SDX, HAC_6_SHOW))) {
                dxCode.mark(MsdrgCode.CodeFlag.ON_SHOW_LIST);
            }
            Optional<Integer> maybeClinSig = this.diagnosisAccess.getClinicalSignificanceOfCode(dxCode.getValue());
            maybeClinSig.ifPresent(dxCode::setClinicalSignificanceRank);
        }
        context = context.toBuilder().withProcessingData(processingData.toBuilder().withSdxCodes(sdxCodes).build()).build();
        context.getTraceUtility().traceSdxCodes(processingData.getSdxCodes());
        return new Link.LinkResult(context, true);
    }
}

