/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.preprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.model.v2.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.ast.SupplierFactory;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.ArrayList;
import java.util.HashMap;

public class SupplierSetup
implements Link {
    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        context = this.setupDxSuppliers(context);
        context = this.setupProcSuppliers(context);
        return new Link.LinkResult(context, true);
    }

    private ProcessingContext setupProcSuppliers(ProcessingContext context) {
        HashMap<String, NodeSupplier<DrgLexerToken, AstContext>> suppliers = new HashMap<String, NodeSupplier<DrgLexerToken, AstContext>>(context.getSupplierMap());
        suppliers.putAll(SupplierFactory.getProcedureSuppliers());
        return context.toBuilder().withSupplierMap(suppliers).build();
    }

    private ProcessingContext setupDxSuppliers(ProcessingContext context) {
        RuntimeOptions runtime = context.getRuntime();
        ProcessingData processingData = context.getProcessingData();
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        if (runtime.getMarkingLogicTieBreaker() == MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE) {
            sdxCodes.sort((o1, o2) -> {
                if (!o1.is(MsdrgCode.CodeFlag.VALID)) {
                    return 1;
                }
                if (!o2.is(MsdrgCode.CodeFlag.VALID)) {
                    return -1;
                }
                return o1.getClinicalSignificanceRank().compareTo(o2.getClinicalSignificanceRank());
            });
        }
        HashMap<String, NodeSupplier<DrgLexerToken, AstContext>> suppliers = new HashMap<String, NodeSupplier<DrgLexerToken, AstContext>>(context.getSupplierMap());
        suppliers.putAll(SupplierFactory.getDiagnosisSuppliers());
        context = context.toBuilder().withProcessingData(processingData.toBuilder().withSdxCodes(sdxCodes).build()).withSupplierMap(suppliers).build();
        return context;
    }
}

