/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.model;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class ClusterChoices {
    private final Map<Integer, Map<String, String>> choices;

    private ClusterChoices(Map<Integer, Map<String, String>> choices) {
        this.choices = choices;
    }

    public Optional<Integer> contains(String code) {
        for (Map.Entry<Integer, Map<String, String>> entry : this.choices.entrySet()) {
            String codeFound = entry.getValue().get(code);
            if (codeFound == null) continue;
            return Optional.ofNullable(entry.getKey());
        }
        return Optional.empty();
    }

    public Optional<Integer> contains(String code, BitSet choiceToIgnore) {
        for (Map.Entry<Integer, Map<String, String>> entry : this.choices.entrySet()) {
            String codeFound;
            if (choiceToIgnore.get(entry.getKey() - 1) || (codeFound = entry.getValue().get(code)) == null) continue;
            return Optional.ofNullable(entry.getKey());
        }
        return Optional.empty();
    }

    public int getChoiceCount() {
        return this.choices.size();
    }

    public static ClusterChoicesBuilder builder() {
        return new ClusterChoicesBuilder();
    }

    public static final class ClusterChoicesBuilder {
        private final Map<Integer, Map<String, String>> choices = new HashMap<Integer, Map<String, String>>();

        private ClusterChoicesBuilder() {
        }

        public ClusterChoicesBuilder withChoices(Map<Integer, Set<String>> choices) {
            for (Map.Entry<Integer, Set<String>> entry : choices.entrySet()) {
                this.withChoice(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public ClusterChoicesBuilder withChoice(int choiceNumber, Set<String> codes) {
            Map<String, String> map = codes.stream().collect(Collectors.toMap(item -> item, item -> item));
            this.choices.put(choiceNumber, map);
            return this;
        }

        public ClusterChoices build() {
            return new ClusterChoices(this.choices);
        }
    }
}

