/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.utility.farser.ast.parser;

import gov.agency.msdrg.v400.utility.farser.ast.DrgSyntaxTree;
import gov.agency.msdrg.v400.utility.farser.ast.node.operator.And;
import gov.agency.msdrg.v400.utility.farser.ast.node.operator.Not;
import gov.agency.msdrg.v400.utility.farser.ast.node.operator.Or;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.BooleanExpression;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.lexer.FarserException;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgFormulaToken;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class DescentParser<T> {
    private BooleanExpression<T> root;
    private DrgLexerToken currentToken;
    private ListIterator<DrgLexerToken> tokenIterator;
    private final NodeSupplier<DrgLexerToken, T> defaultSupplier;
    private final Map<String, NodeSupplier<DrgLexerToken, T>> suppliers;

    public DescentParser(ListIterator<DrgLexerToken> tokenIterator, NodeSupplier<DrgLexerToken, T> defaultSupplier, Map<String, NodeSupplier<DrgLexerToken, T>> suppliers) {
        this.tokenIterator = tokenIterator;
        this.currentToken = tokenIterator.next();
        if (defaultSupplier == null) {
            throw new FarserException("Please provide at least a default supplier argument to DescentParser constructor");
        }
        this.defaultSupplier = defaultSupplier;
        this.suppliers = suppliers == null ? new HashMap<String, NodeSupplier<DrgLexerToken, T>>() : suppliers;
    }

    public void setTokenIterator(ListIterator<DrgLexerToken> tokenIterator) {
        this.tokenIterator = tokenIterator;
        this.currentToken = tokenIterator.next();
    }

    public DrgSyntaxTree<T> buildExpressionTree() {
        this.expression();
        return this.getAst();
    }

    private void expression() {
        this.term();
        while (this.currentToken.getType() == DrgFormulaToken.OR) {
            this.eat(DrgFormulaToken.OR);
            Or<T> or = new Or<T>();
            or.setLeft(this.root);
            this.term();
            or.setRight(this.root);
            this.root = or;
        }
    }

    private void term() {
        this.factor();
        while (this.currentToken.getType() == DrgFormulaToken.AND) {
            this.eat(DrgFormulaToken.AND);
            And<T> and = new And<T>();
            and.setLeft(this.root);
            this.factor();
            and.setRight(this.root);
            this.root = and;
        }
    }

    private void factor() {
        if (this.currentToken.getType() == DrgFormulaToken.ATOM) {
            NodeSupplier<DrgLexerToken, DrgLexerToken> nodeSupplier = this.suppliers.getOrDefault(this.currentToken.value, this.defaultSupplier);
            this.root = nodeSupplier.createNode(this.currentToken);
            this.eat(DrgFormulaToken.ATOM);
        } else if (this.currentToken.getType() == DrgFormulaToken.LPAREN) {
            this.eat(DrgFormulaToken.LPAREN);
            this.expression();
            this.eat(DrgFormulaToken.RPAREN);
        } else if (this.currentToken.getType() == DrgFormulaToken.NOT) {
            this.eat(DrgFormulaToken.NOT);
            Not<T> not = new Not<T>();
            this.factor();
            not.setChild(this.root);
            this.root = not;
        } else {
            throw new FarserException("Expression Malformed on token " + this.currentToken);
        }
    }

    private void eat(DrgFormulaToken type) {
        if (this.currentToken.getType() == type && this.tokenIterator.hasNext()) {
            this.currentToken = this.tokenIterator.next();
        }
    }

    private DrgSyntaxTree<T> getAst() {
        return new DrgSyntaxTree<T>(this.root);
    }
}

