/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.grouper.mainframe.date;

import gov.agency.mainframe.utility.v310.MainframeWrapperException;
import gov.cms.grouper.mainframe.date.DateBeforeValidVersionException;
import gov.cms.grouper.mainframe.date.MalformedDateException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public enum VersionDate {
    VERSION_390(390, "20211001", "20220331"),
    VERSION_391(391, "20220401", "20220930"),
    VERSION_400(400, "20221001", null);

    private static final String MALFORMED_MESSAGE = "Malformed date";
    private static final String BEFORE_MESSAGE = "Date is before any valid versions";
    private static final DateTimeFormatter FORMATTER;
    private final LocalDate startDate;
    private final LocalDate endDate;
    private final int version;

    private VersionDate(int version, String startDate, String endDate) {
        DateTimeFormatter ctorFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        this.startDate = LocalDate.parse(startDate, ctorFormatter);
        this.endDate = endDate != null ? LocalDate.parse(endDate, ctorFormatter) : null;
        this.version = version;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public Optional<LocalDate> getEndDate() {
        return Optional.ofNullable(this.endDate);
    }

    public int getVersion() {
        return this.version;
    }

    public static VersionDate getVersionFromDate(String date) throws MainframeWrapperException {
        if (date != null) {
            LocalDate localDate;
            try {
                localDate = LocalDate.parse(date, FORMATTER);
            }
            catch (DateTimeParseException exc) {
                throw new MalformedDateException(MALFORMED_MESSAGE);
            }
            for (VersionDate value : VersionDate.values()) {
                if (!VersionDate.isWithin(localDate, value.startDate, value.endDate)) continue;
                return value;
            }
        } else {
            throw new MalformedDateException(MALFORMED_MESSAGE);
        }
        throw new DateBeforeValidVersionException(BEFORE_MESSAGE);
    }

    private static boolean isWithin(LocalDate date, LocalDate startDate, LocalDate endDate) {
        if (endDate == null) {
            return startDate.equals(date) || startDate.isBefore(date);
        }
        return startDate.equals(date) || endDate.equals(date) || startDate.isBefore(date) && endDate.isAfter(date);
    }

    public String toString() {
        StringBuilder sj = new StringBuilder();
        sj.append(this.name());
        sj.append(": ");
        sj.append(this.startDate.toString());
        sj.append(" - ");
        if (this.endDate != null) {
            sj.append(this.endDate.toString());
        }
        return sj.toString();
    }

    static {
        FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    }
}

