/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.data.meta.enumer.ComorbidityLevel_EN;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.diagnosis.ComorbidityGroup;
import gov.cms.hh.diagnosis.ComorbidityInteraction;
import gov.cms.hh.diagnosis.ComorbidityInteractionIF;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.logic.processor.HippsPositionAbstract;
import gov.cms.hh.logic.processor.HippsPositionIF;
import gov.cms.hh.logic.specification.IsInComorbidityInteraction;
import gov.cms.hh.reference.objects.ComorbidityInteractionObject;
import java.util.ArrayList;
import java.util.List;

public class HippsPosition4
extends HippsPositionAbstract
implements HippsPositionIF {
    public HippsPosition4(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public boolean calculate() {
        int HIPPS_POSITION = 4;
        ComorbidityLevel_EN hippsValue = ComorbidityLevel_EN.NO_COMORBIDITY;
        DiagnosisIF pdx = this.getClaim().getPrimaryDiagnosis();
        List<DiagnosisIF> sdxList = this.getClaim().getSecondaryDiagnoses().getCollection();
        ArrayList<DiagnosisIF> sdxComorbidityList = new ArrayList<DiagnosisIF>();
        for (DiagnosisIF dx : sdxList) {
            if (dx.getEditCollection().hasEditId(EditId_EN.VALUE_VALID) && !dx.getEditCollection().hasEditId(EditId_EN.VALUE_IGNORE)) {
                if (dx.getComorbidityGroup().isComorbidityPresent()) {
                    String logText = "SDX = " + dx.getValue() + " (" + dx.getDescription() + ") with Comorbidity Group = " + dx.getComorbidityGroup().getName() + " is eligible for comorbidity determination";
                    if (!pdx.getEditCollection().hasCriticalEdits()) {
                        if (dx.getDiagnosisSubchapter().getId() != pdx.getDiagnosisSubchapter().getId()) {
                            sdxComorbidityList.add(dx);
                            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, logText);
                            continue;
                        }
                        String subChapter = dx.getDiagnosisSubchapter().getDxFrom() + "-" + dx.getDiagnosisSubchapter().getDxTo() + " " + dx.getDiagnosisSubchapter().getDescription();
                        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "SDX = " + dx.getValue() + " (" + dx.getDescription() + ") has comorbidity but from the same DX subchapter as PDX (" + subChapter + "). Not eligible for comorbidity determination");
                        continue;
                    }
                    sdxComorbidityList.add(dx);
                    this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, logText + " but PDX is invalid or ungroupable and HIPPS value won't be accurate");
                    continue;
                }
                this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "SDX = " + dx.getValue() + " (" + dx.getDescription() + ")) has no comorbidity");
                continue;
            }
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "SDX = " + dx.getValue() + " is invalid DX");
        }
        if (!sdxComorbidityList.isEmpty()) {
            List<ComorbidityInteractionIF> allInteractionList = this.getInitalComorbidityInteractionList();
            List<ComorbidityInteractionIF> resultInteractionList = this.checkComorbidityInteraction(allInteractionList, sdxComorbidityList);
            if (!resultInteractionList.isEmpty()) {
                hippsValue = ComorbidityLevel_EN.HIGH_COMORBIDITY;
                resultInteractionList.forEach(cInter -> this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "Comorbidity interaction = " + cInter.getId() + ", " + cInter.getComorbidityGroup1().getName() + " (SDX=" + this.findDxByComorbidity(sdxList, cInter.getComorbidityGroup1().getName()).getValue() + ") / " + cInter.getComorbidityGroup2().getName() + " (SDX=" + this.findDxByComorbidity(sdxList, cInter.getComorbidityGroup2().getName()).getValue() + ") is used for high comorbidity adjustment"));
                this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "Comorbidity interaction(s) found for high comorbidity adjustment");
            } else {
                this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "No high comorbidity (interactions) found in SDX list");
                if (this.isLowComorbidity(sdxComorbidityList)) {
                    hippsValue = ComorbidityLevel_EN.LOW_COMORBIDITY;
                }
            }
        }
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "HIPPS Position 4 = " + hippsValue.getId() + " (" + hippsValue.getDescription() + ")");
        return this.setHippsCode(4, "" + hippsValue.getId());
    }

    private boolean isLowComorbidity(List<DiagnosisIF> dxList) {
        for (DiagnosisIF dx : dxList) {
            if (dx.getEditCollection().hasEditId(EditId_EN.VALUE_IGNORE) || !dx.getComorbidityGroup().isLowComorbidity()) continue;
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "First SDX found for low comorbidity adjustment = " + dx.getValue());
            return true;
        }
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS4, "No low comorbidity found in SDX list");
        return false;
    }

    private List<ComorbidityInteractionIF> checkComorbidityInteraction(List<ComorbidityInteractionIF> ciList, List<DiagnosisIF> dxList) {
        List<ComorbidityInteractionIF> ciLeftList = this.checkComorbidityInteraction(ciList, dxList, true);
        List<ComorbidityInteractionIF> ciRightList = this.checkComorbidityInteraction(ciLeftList, dxList, false);
        return ciRightList;
    }

    private List<ComorbidityInteractionIF> checkComorbidityInteraction(List<ComorbidityInteractionIF> ciList, List<DiagnosisIF> dxList, boolean isLeft) {
        ArrayList<ComorbidityInteractionIF> retList = new ArrayList<ComorbidityInteractionIF>();
        IsInComorbidityInteraction check = new IsInComorbidityInteraction(dxList);
        ciList.forEach(ci -> {
            ComorbidityGroup cg;
            ComorbidityGroup comorbidityGroup = cg = isLeft ? ci.getComorbidityGroup1() : ci.getComorbidityGroup2();
            if (check.isSatisfiedBy(cg)) {
                retList.add((ComorbidityInteractionIF)ci);
            }
        });
        return retList;
    }

    private List<ComorbidityInteractionIF> getInitalComorbidityInteractionList() {
        ArrayList<ComorbidityInteractionIF> retList = new ArrayList<ComorbidityInteractionIF>();
        List ciDtoList = this.getDataManager().getDataMap().get(TableNames_EN.Comorbidity_Interactions).getData();
        for (ComorbidityInteractionObject ciObj : ciDtoList) {
            ComorbidityGroup cg1 = new ComorbidityGroup(0, ciObj.getGroup1(), null, false);
            ComorbidityGroup cg2 = new ComorbidityGroup(0, ciObj.getGroup2(), null, false);
            ComorbidityInteraction ci = new ComorbidityInteraction(Integer.parseInt(ciObj.getId()), cg1, cg2);
            retList.add(ci);
        }
        return retList;
    }
}

