/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.reference.objects;

import gov.cms.hh.data.interf.RecordLayoutIF;
import gov.cms.hh.xml.layout.claim.ClaimField;
import gov.cms.hh.xml.layout.claim.ClaimLayout;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author CMS
 */
public class ClaimLayoutObject extends ClaimLayout implements RecordLayoutIF {
    
    /**
     *
     * @return
     */
    @Override
    public List<Integer> getLayout() {
        List<Integer> retList = null;
        if (getClaimField() != null) {
            for (ClaimField clFld : getClaimField()) {
                if (retList == null) {
                    retList = new ArrayList();
                }
                retList.addAll(getLayout(Integer.parseInt(clFld.getSequence())));
            }
        }
        return retList;
    }

    private List<Integer> getLayout(int fieldNumber) {
        List<Integer> retList = null;
        if (getClaimField() != null) {
            for (ClaimField clFld : getClaimField()) {
                if (Integer.parseInt(clFld.getSequence()) == fieldNumber) {
                    for (int i = 0; i < Integer.parseInt(clFld.getOccurrence()); i++) {
                        if (retList == null) {
                            retList = new ArrayList();
                        }
                        retList.add(Integer.parseInt(clFld.getLength()));
                    }
                }
            }
        }
        return retList;
    }

/*
    @Override
    public List<LayoutElementIF> getExtendedLayout() {
        List<LayoutElementIF> retList = null;
        if (getClaimField() != null) {
            for (ClaimField clFld : getClaimField()) {
                if (retList == null) {
                    retList = new ArrayList();
                }
                retList.addAll(getExtendedLayout(Integer.parseInt(clFld.getSequence())));
            }
        }
        return retList;
    }

    private List<LayoutElementIF> getExtendedLayout(int fieldNumber) {
        List<LayoutElementIF> retList = null;
        if (getClaimField() != null) {
            for (ClaimField clFld : getClaimField()) {
                if (Integer.parseInt(clFld.getSequence()) == fieldNumber) {
                    for (int i = 0; i < Integer.parseInt(clFld.getOccurrence()); i++) {
                        if (retList == null) {
                            retList = new ArrayList();
                        }
                        ClaimFieldObject le = clone(clFld);
                        int newPos = le.getElementPosition() + le.getElementLength() * i;
                        le.setPosition("" + newPos);
                        le.setOccurrence("" + 1);
                        retList.add(le);
                    }
                }
            }
        }
        return retList;
    }
*/
    /* custom clone */
//    private ClaimFieldObject clone(ClaimField clFld) {
//        ClaimFieldObject lo = new ClaimFieldObject();
//        lo.setDescription(clFld.getDescription());
//        lo.setLength(clFld.getLength());
//        lo.setName(clFld.getName());
//        lo.setOccurrence(clFld.getOccurrence());
//        lo.setPosition(clFld.getPosition());
//        lo.setSequence(clFld.getSequence());
//        lo.setSource(clFld.getSource());
//        lo.setType(clFld.getType());
//        return lo;
//    }

}
