/*
 * Decompiled with CFR 0.152.
 */
package com.modal;

import com.utilities.formattor.ReportHeaders;
import com.utilities.formattor.StringFormattor;
import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.logic.validation.EditIF;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Grouper
extends ReportHeaders {
    private static String formattedOutput;
    private final ClaimContainerIF claimContainer;

    public Grouper(ClaimContainerIF claimContainer) {
        this.claimContainer = claimContainer;
    }

    public static void writeOutputToFile(File f) {
        try {
            File outputFile = new File(f.getAbsolutePath());
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));
            writer.write(formattedOutput);
            writer.close();
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public String getOutputReport(boolean isDetailed) {
        StringBuilder sb = new StringBuilder(Grouper.getHomeHealthTitle());
        this.printHIPPS(isDetailed, sb);
        this.printClaimOutput(isDetailed, sb);
        this.printClinicalFields(isDetailed, sb);
        this.printPDX(isDetailed, sb);
        if (isDetailed) {
            this.printFunctionalFields(true, sb);
            this.printSDX(true, sb);
        } else {
            this.printSDX(false, sb);
            this.printFunctionalFields(false, sb);
        }
        this.printVersionInformation(sb);
        formattedOutput = sb.toString();
        return sb.toString();
    }

    private void printHIPPS(boolean isDetailed, StringBuilder sb) {
        sb.append(Grouper.getHippsTitle());
        ReportHeaders.valueWithLabel("-HIPPS Code", this.claimContainer.getHippsCode(), sb);
    }

    private void printClaimOutput(boolean isDetailed, StringBuilder sb) {
        sb.append(Grouper.getGrouperReturnTitle());
        Grouper.valueWithLabel("-Return Code", String.format("%s (%s)", this.claimContainer.getReturnCodeDescription(), this.claimContainer.getReturnCodeValue()), sb);
        this.printEdits(isDetailed, sb, EditId_EN.VALUE_RETURN);
        sb.append(Grouper.getValidityTitle());
        Grouper.valueWithLabel("-Validity Flag", String.format("%s (%s)", this.claimContainer.getValidityFlagDescription(), this.claimContainer.getValidityFlagValue()), sb);
    }

    private void printClinicalFields(boolean isDetailed, StringBuilder sb) {
        if (isDetailed) {
            sb.append(Grouper.getHippsTitle1());
        } else {
            sb.append(Grouper.getClinicalFieldsTitle());
        }
        Grouper.valueWithLabel("-Claim ID", this.claimContainer.getClaimId(), sb);
        Grouper.valueWithLabel("-From Date", this.claimContainer.getFromDate(), sb);
        Grouper.valueWithLabel("-Period Timing", this.claimContainer.getPeriodTiming(), sb);
        Grouper.valueWithLabel("-Referral Source", this.claimContainer.getReferralSource(), sb);
        this.printEdits(isDetailed, sb, EditId_EN.VALUE_HIPPS1);
    }

    private void printPDX(boolean isDetailed, StringBuilder sb) {
        if (isDetailed) {
            sb.append(Grouper.getHippsTitle2());
        } else {
            sb.append(Grouper.getPdxDiagnosisCodesTitle());
        }
        Grouper.valueWithLabel("-Principal Diagnosis", Grouper.codeWithDescription(this.claimContainer.getPdx().getDx(), this.claimContainer.getFromDate()), sb);
        this.printEdits(isDetailed, sb, EditId_EN.VALUE_HIPPS2);
    }

    private void printFunctionalFields(boolean isDetailed, StringBuilder sb) {
        if (isDetailed) {
            sb.append(Grouper.getHippsTitle3());
        } else {
            sb.append(Grouper.getFunctionalFieldsTitle());
        }
        Grouper.valueWithLabel("-M1033 Falls", this.claimContainer.getHospRiskHistoryFalls(), sb);
        Grouper.valueWithLabel("-M1033 WeightLoss", this.claimContainer.getHospRiskWeightLoss(), sb);
        Grouper.valueWithLabel("-M1033 MultipleHospitalizations", this.claimContainer.getHospRiskMultiHospital(), sb);
        Grouper.valueWithLabel("-M1033 MultipleEdVisits", this.claimContainer.getHospRiskWeightLoss(), sb);
        Grouper.valueWithLabel("-M1033 MentalBehaviorDecline", this.claimContainer.getHospRiskMentalBehavDecl(), sb);
        Grouper.valueWithLabel("-M1033 Compliance", this.claimContainer.getHospRiskCompliance(), sb);
        Grouper.valueWithLabel("-M1033 FiveOrMoreMedications", this.claimContainer.getHospRiskFiveMoreMeds(), sb);
        Grouper.valueWithLabel("-M1033 Exhaustion", this.claimContainer.getHospRiskExhaustion(), sb);
        Grouper.valueWithLabel("-M1033 OtherRisks", this.claimContainer.getHospRiskOtherRisk(), sb);
        Grouper.valueWithLabel("-M1033 NoneOfAbove", this.claimContainer.getHospRiskNoneAbove(), sb);
        Grouper.valueWithLabel("-M1800 Grooming ", this.claimContainer.getGrooming(), sb);
        Grouper.valueWithLabel("-M1810 DressUpperBody ", this.claimContainer.getDressUpper(), sb);
        Grouper.valueWithLabel("-M1820 DressLowerBody ", this.claimContainer.getDressLower(), sb);
        Grouper.valueWithLabel("-M1830 Bathing ", this.claimContainer.getBathing(), sb);
        Grouper.valueWithLabel("-M1840 Toileting ", this.claimContainer.getToileting(), sb);
        Grouper.valueWithLabel("-M1850 Transferring ", this.claimContainer.getTransferring(), sb);
        Grouper.valueWithLabel("-M1860 Ambulation ", this.claimContainer.getAmbulation(), sb);
        this.printEdits(isDetailed, sb, EditId_EN.VALUE_HIPPS3);
    }

    private void printSDX(boolean isDetailed, StringBuilder sb) {
        if (isDetailed) {
            sb.append(Grouper.getHippsTitle4());
        } else {
            sb.append(Grouper.getSdxDiagnosisCodesTitle());
        }
        if (this.claimContainer.getSdxList() != null) {
            for (int i = 0; i < this.claimContainer.getSdxList().size(); ++i) {
                Grouper.valueWithLabel("-Secondary Diagnosis(" + (i + 1) + ")", Grouper.codeWithDescription(this.claimContainer.getSdxList().get(i).getDx(), this.claimContainer.getFromDate()), sb);
            }
        } else {
            Grouper.valueWithLabel("-Secondary Diagnosis", "None entered", sb);
        }
        this.printEdits(isDetailed, sb, EditId_EN.VALUE_HIPPS4);
    }

    private void printVersionInformation(StringBuilder sb) {
        sb.append(Grouper.getVersionTitle());
        Grouper.valueWithLabel("-Component Version Used", this.claimContainer.getVersionUsed(), sb);
    }

    private void printEdits(boolean isDetailed, StringBuilder sb, EditId_EN edit) {
        if (isDetailed) {
            Grouper.valueWithLabel(StringFormattor.getSpaces(4) + "-" + edit.getDescription(), "", sb);
            for (EditIF e : this.claimContainer.getEdits().getEditId(edit)) {
                Grouper.valueWithLabel(StringFormattor.getSpaces(8) + "-" + e.getServerityLevel(), e.getDescription(), sb);
            }
        }
    }
}

