/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.claim;

import gov.cms.hh.claim.Claim;
import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.claim.DateFrom;
import gov.cms.hh.claim.OasisResponse;
import gov.cms.hh.claim.PeriodTiming;
import gov.cms.hh.claim.ReferralSource;
import gov.cms.hh.data.exchange.ClaimContainerIF;
import gov.cms.hh.data.exchange.DxContainerIF;
import gov.cms.hh.data.meta.enumer.Oasis_EN;
import gov.cms.hh.data.meta.enumer.PeriodTiming_EN;
import gov.cms.hh.data.meta.enumer.ReferralSource_EN;
import gov.cms.hh.diagnosis.Diagnosis;
import java.util.List;
import java.util.Map;

public class ClaimAdapter {
    public ClaimContainerIF convert(ClaimIF claimIn) {
        return null;
    }

    public ClaimIF convert(ClaimContainerIF claimIn) {
        Claim retClaim = new Claim();
        retClaim.setClaimId(claimIn.getClaimId());
        DateFrom df = new DateFrom();
        df.setValue(claimIn.getFromDate());
        retClaim.setDateFrom(df);
        PeriodTiming pt = new PeriodTiming();
        String ptVal = claimIn.getPeriodTiming();
        pt.setValue(ptVal);
        pt.setDescription(this.getPeriodTimingDescription(ptVal));
        retClaim.setPeriodTiming(pt);
        ReferralSource rf = new ReferralSource();
        String rfVal = claimIn.getReferralSource();
        rf.setValue(rfVal);
        rf.setDescription(this.getReferralSourceDescription(rfVal));
        retClaim.setReferralSource(rf);
        Diagnosis pdx = new Diagnosis();
        if (claimIn.getPdx() != null) {
            pdx.setValue(claimIn.getPdx().getDx().trim().toUpperCase());
        }
        retClaim.setPrimaryDiagnosis(pdx);
        List<DxContainerIF> sdxList = claimIn.getSdxList();
        if (sdxList != null) {
            for (DxContainerIF dx : sdxList) {
                if (dx == null || dx.getDx().trim().isEmpty()) break;
                Diagnosis sdx = new Diagnosis();
                sdx.setValue(dx.getDx().trim().toUpperCase());
                retClaim.getSecondaryDiagnoses().getCollection().add(sdx);
            }
        }
        Map<String, String> ffMap = claimIn.getFunctionalFields();
        for (Map.Entry<String, String> entry : ffMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            OasisResponse oasisResponse = new OasisResponse();
            oasisResponse.setType(Oasis_EN.valueOf(key));
            oasisResponse.setValue(value);
            retClaim.getOasisFields().getCollection().add(oasisResponse);
        }
        return retClaim;
    }

    private String getPeriodTimingDescription(String inValue) {
        if (inValue == null) {
            return null;
        }
        for (PeriodTiming_EN value : PeriodTiming_EN.values()) {
            if (!("" + value.getId()).equalsIgnoreCase(inValue.trim())) continue;
            return value.getDescription();
        }
        return null;
    }

    private String getReferralSourceDescription(String inValue) {
        if (inValue == null) {
            return null;
        }
        for (ReferralSource_EN value : ReferralSource_EN.values()) {
            if (!("" + value.getId()).equalsIgnoreCase(inValue.trim())) continue;
            return value.getDescription();
        }
        return null;
    }
}

