<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.w3.org/1999/XSL/Format ">
    <xsl:output method="text" omit-xml-declaration="yes"/>
    <xsl:template match="/">
        <xsl:for-each select="Claims/Claim">
----------------------- HomeHealth Grouper ------------------------------------
----------------------- HIPPS Code (Output) -----------------------------------
    -Episode Timing : <xsl:value-of select="Output/HippsCode/@EpisodeTiming"/>
    -Clinical Group : <xsl:value-of select="Output/HippsCode/@ClinicalGroup"/>
    -Functional Level : <xsl:value-of select="Output/HippsCode/@FunctionalLevel"/>
    -Comorbidity Present : <xsl:value-of select="Output/HippsCode/@ComorbidityPresent"/>
----------------------- Grouper Return (Output) -------------------------------
    -Return Code (<xsl:value-of select="Output/GrouperReturnCode/@Value"/>) : <xsl:value-of select="Output/GrouperReturnCode/@Description"/>
----------------------- Clinical Fields (Input) -------------------------------
    -Claim ID: <xsl:value-of select="@Id"/>
    -From Date: <xsl:value-of select="Input/ClinicalFields/@FromDate"/>
    -Period Timing: <xsl:value-of select="Input/ClinicalFields/@PeriodTiming"/>
    -Referral Source: <xsl:value-of select="Input/ClinicalFields/@ReferralSource"/>
----------------------- Diagnosis Codes (Input)--------------------------------
    -Principal Diagnosis : <xsl:value-of select="Input/ClinicalFields/Diagnoses/Principal/Dx/@Code"/> : <xsl:value-of select="Input/ClinicalFields/Diagnoses/Principal/Dx/@Description"/> 
<xsl:for-each select="Input/ClinicalFields/Diagnoses/Secondary/Dx">
    -Secondary Diagnosis(<xsl:value-of select="@Occurance"/>) : <xsl:value-of select="@Code"/> : <xsl:value-of select="@Description"/>
</xsl:for-each>
----------------------- Functional Fields (Input) ----------------------------- <xsl:for-each select="Input/FunctionalFields/FunctionalField">
<xsl:for-each select="Subfield">
    -<xsl:value-of select="../@FieldId"/> : <xsl:value-of select="@Name"/> : <xsl:value-of select="@Value"/>
</xsl:for-each>
</xsl:for-each>
----------------------- Version Information (Output) --------------------------
    -Version: <xsl:value-of select="Output/VersionUsed/@Version"/>
    -Release:<xsl:value-of select="Output/VersionUsed/@Release"/>
    -Year:<xsl:value-of select="Output/VersionUsed/@Year"/>
</xsl:for-each>
    </xsl:template>
</xsl:stylesheet>