/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.diagnosis;

import gov.cms.hh.claim.ClaimElementBase;
import gov.cms.hh.reference.objects.DiagnosisObject;

/**
 *
 * @author CMS
 */
public class Diagnosis extends ClaimElementBase implements DiagnosisIF {

    /**
     * @return the codeFirst
     */
    public boolean isCodeFirst() {
        return codeFirst;
    }

    /**
     * @param codeFirst the codeFirst to set
     */
    public void setCodeFirst(boolean codeFirst) {
        this.codeFirst = codeFirst;
    }

    /**
     * @return the unacceptablePdx
     */
    public boolean isUnacceptablePdx() {
        return unacceptablePdx;
    }

    /**
     * @param unacceptablePdx the unacceptablePdx to set
     */
    public void setUnacceptablePdx(boolean unacceptablePdx) {
        this.unacceptablePdx = unacceptablePdx;
    }

    private static final long serialVersionUID = 1L;
    
    @Override
    public String toString() {
        return "Diagnosis{" + "id=" + id + ", value=" + value + ", description=" 
                + description + ", manifestation=" + manifestation 
                + ", primaryAwarding=" + primaryAwarding + ", ECOI=" + ECOI 
                + ", codeFirst=" + codeFirst + ", unacceptablePdx=" + unacceptablePdx 
                + ", clinicalGroup=" + clinicalGroup + ", comorbidityGroup=" 
                + comorbidityGroup + ", diagnosisSubchapter=" + diagnosisSubchapter + '}';
    }

    /**
     * Constructor
     */
    public Diagnosis() {
        super();
    }

    /**
     *
     * @param id
     * @param value
     * @param description
     * @param manifestation
     * @param primaryAwarding
     * @param ECOI
     * @param codeFirst
     * @param unacceptablePdx
     * @param clinicalGroup
     * @param comorbidityGroup
     * @param diagnosisSubchapter
     */
    public Diagnosis(int id,
            String value,
            String description,
            boolean manifestation,
            boolean primaryAwarding,
            boolean ECOI,
            boolean codeFirst,
            boolean unacceptablePdx,
            ClinicalGroup clinicalGroup,
            ComorbidityGroup comorbidityGroup,
            DiagnosisSubchapter diagnosisSubchapter) {
        super();
        this.id = id;
        this.value = value;
        this.description = description;
        this.manifestation = manifestation;
        this.primaryAwarding = primaryAwarding;
        this.ECOI = ECOI;
        this.codeFirst = codeFirst;
        this.unacceptablePdx = unacceptablePdx;
        this.clinicalGroup = clinicalGroup;
        this.comorbidityGroup = comorbidityGroup;
        this.diagnosisSubchapter = diagnosisSubchapter;
    }

    /**
     *
     * @param id
     * @param diagObj
     * @param clinicalGroup
     * @param comorbidityGroup
     * @param diagnosisSubchapter
     */
    public Diagnosis(int id,
            DiagnosisObject diagObj,
            ClinicalGroup clinicalGroup,
            ComorbidityGroup comorbidityGroup,
            DiagnosisSubchapter diagnosisSubchapter) {
        this(id,
                diagObj.getValue(),
                diagObj.getDescription(),
                Integer.parseInt(diagObj.getManifestationFlag()) > 0,
                Integer.parseInt(diagObj.getPrimaryAwardingFlag()) > 0,
                Integer.parseInt(diagObj.getEcoiFlag()) > 0,
                Integer.parseInt(diagObj.getCodeFirstFlag()) > 0,
                Integer.parseInt(diagObj.getUnacceptablePdxFlag()) > 0,
                clinicalGroup,
                comorbidityGroup,
                diagnosisSubchapter
        );

    }

    /**
     * @return the clinicalGroup
     */
    @Override
    public ClinicalGroup getClinicalGroup() {
        return clinicalGroup;
    }

    /**
     * @param clinicalGroup the clinicalGroup to set
     */
    @Override
    public void setClinicalGroup(ClinicalGroup clinicalGroup) {
        this.clinicalGroup = clinicalGroup;
    }

    /**
     * @return the comorbidityGroup
     */
    @Override
    public ComorbidityGroup getComorbidityGroup() {
        return comorbidityGroup;
    }

    /**
     * @param comorbidityGroup the comorbidityGroup to set
     */
    @Override
    public void setComorbidityGroup(ComorbidityGroup comorbidityGroup) {
        this.comorbidityGroup = comorbidityGroup;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

    /**
     * @return the value
     */
    @Override
    public String getValue() {
        return value;
    }

    /**
     * @param value the value to set
     */
    @Override
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * @return the description
     */
    @Override
    public String getDescription() {
        return description;
    }

    /**
     * @param description the description to set
     */
    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return the manifestation
     */
    @Override
    public boolean isManifestation() {
        return manifestation;
    }

    /**
     * @param manifestation the manifestation to set
     */
    @Override
    public void setManifestation(boolean manifestation) {
        this.manifestation = manifestation;
    }

    /**
     * @return the primaryAwarding
     */
    @Override
    public boolean isPrimaryAwarding() {
        return primaryAwarding;
    }

    /**
     * @param primaryAwarding the primaryAwarding to set
     */
    @Override
    public void setPrimaryAwarding(boolean primaryAwarding) {
        this.primaryAwarding = primaryAwarding;
    }

    /**
     * @return the ECOI
     */
    @Override
    public boolean isECOI() {
        return ECOI;
    }

    /**
     * @param ECOI the ECOI to set
     */
    @Override
    public void setECOI(boolean ECOI) {
        this.ECOI = ECOI;
    }

    private int id;
    private String value;
    private String description;
    private boolean manifestation;
    private boolean primaryAwarding;
    private boolean ECOI;
    private boolean codeFirst;
    private boolean unacceptablePdx;
    private ClinicalGroup clinicalGroup;
    private ComorbidityGroup comorbidityGroup;
    private DiagnosisSubchapter diagnosisSubchapter;

    /**
     * @return the diagnosisSubchapter
     */
    @Override
    public DiagnosisSubchapter getDiagnosisSubchapter() {
        return diagnosisSubchapter;
    }

    /**
     * @param diagnosisSubchapter the diagnosisSubchapter to set
     */
    @Override
    public void setDiagnosisSubchapter(DiagnosisSubchapter diagnosisSubchapter) {
        this.diagnosisSubchapter = diagnosisSubchapter;
    }

}
