/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.specification;

import gov.cms.hh.data.meta.enumer.ReferralSource_EN;
import gov.cms.hh.logic.specification.abstr.AbstractSpecification;

/**
 *
 * @author CMS
 */
public class IsValidReferralSource extends AbstractSpecification<ReferralSource_EN[]> {

	private final String value;
	
    /**
     *
     * @param value
     */
    public IsValidReferralSource(String value) {
		this.value = value;
	}
	
    /**
     *
     * @param referralSource
     * @return
     */
    @Override
	public boolean isSatisfiedBy(ReferralSource_EN[] referralSource) {
            if(value == null) {
                return false;
            }
            for (ReferralSource_EN val : ReferralSource_EN.values()) {
                if(value.trim().equalsIgnoreCase("" + val.getId())) {
                    return true;
                }
            }
            return false;
	}

}
