/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.data.exchange;

import gov.cms.hh.data.exchange.HippsContainerIF;
import gov.cms.hh.data.exchange.HippsPosition;
import java.util.Map;
import java.util.TreeMap;

public class HippsContainer
implements HippsContainerIF {
    final String VALUE_POSITION_UNAVAILABLE = "NA";
    final String VALUE_UNAVAILABLE = "Value not available";
    Map<Integer, HippsPosition> hipps = new TreeMap<Integer, HippsPosition>();

    public HippsContainer() {
        for (int i = 1; i < 6; ++i) {
            this.hipps.put(i, new HippsPosition("0", "Value not available"));
        }
    }

    private HippsPosition getPosition(int position) {
        HippsPosition naPos = new HippsPosition("NA", "HIPPS position: '" + position + "' not applicable");
        return this.hipps.getOrDefault(position, naPos);
    }

    @Override
    public String getPositionValue(int position) {
        return this.getPosition(position).getValue();
    }

    @Override
    public void setPositionValue(int position, String value) {
        HippsPosition pos = this.getPosition(position);
        if (!pos.getValue().equalsIgnoreCase("NA")) {
            pos.setValue(value);
        }
    }

    @Override
    public String getPositionDescription(int position) {
        return this.getPosition(position).getDescription();
    }

    @Override
    public void setPositionDescription(int position, String description) {
        HippsPosition pos = this.getPosition(position);
        if (!pos.getValue().equalsIgnoreCase("NA")) {
            pos.setDescription(description);
        }
    }

    @Override
    public int getPositionsCount() {
        return this.hipps.size();
    }
}

