/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.grouper;

import gov.cms.hh.data.files.TableNames_EN;
import gov.cms.hh.grouper.DataContainer;
import gov.cms.hh.grouper.DataContainerIF;
import gov.cms.hh.grouper.DataManagerIF;
import gov.cms.hh.reference.objects.ClinicalGroupObject;
import gov.cms.hh.reference.objects.ComorbidityGroupObject;
import gov.cms.hh.reference.objects.ComorbidityInteractionObject;
import gov.cms.hh.reference.objects.DiagnosisObject;
import gov.cms.hh.reference.objects.DiagnosisSubchapterObject;
import gov.cms.hh.reference.objects.HippsValueObject;
import gov.cms.hh.reference.objects.OasisRespondObject;
import gov.cms.hh.reference.objects.ReturnCodeObject;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataManager
implements DataManagerIF {
    private static final Logger LOG = Logger.getLogger(DataManager.class.getName());
    private Map<TableNames_EN, DataContainerIF> dataMap;
    private String rtBasePath;
    private boolean loadDescriptions;

    public DataManager(String rtBasePath, boolean loadDescriptions) {
        this.rtBasePath = rtBasePath;
        this.loadDescriptions = loadDescriptions;
        this.loadOtherData();
    }

    public DataManager(String rtBasePath) {
        this(rtBasePath, false);
    }

    private void loadDxData() {
        String inpFile = this.rtBasePath + "/" + TableNames_EN.Diagnoses.getFileName();
        DataContainer diagnoses = new DataContainer(inpFile, 0, DiagnosisObject.class, this.loadDescriptions);
        this.dataMap.put(TableNames_EN.Diagnoses, diagnoses);
        LOG.log(Level.INFO, "Grouper Data Manager instantiated: DX RT path: {0}, Descriptions loaded: {1}", new Object[]{this.rtBasePath, this.loadDescriptions});
    }

    private void loadOtherData() {
        this.dataMap = new TreeMap<TableNames_EN, DataContainerIF>();
        String inpFile = this.rtBasePath + "/" + TableNames_EN.Clinical_Groups.getFileName();
        DataContainer clinicalGroups = new DataContainer(inpFile, 0, ClinicalGroupObject.class, this.loadDescriptions);
        this.dataMap.put(TableNames_EN.Clinical_Groups, clinicalGroups);
        inpFile = this.rtBasePath + "/" + TableNames_EN.Comorbidity_Groups.getFileName();
        DataContainer comorbidityGroups = new DataContainer(inpFile, 0, ComorbidityGroupObject.class, this.loadDescriptions);
        this.dataMap.put(TableNames_EN.Comorbidity_Groups, comorbidityGroups);
        inpFile = this.rtBasePath + "/" + TableNames_EN.Comorbidity_Interactions.getFileName();
        DataContainer comorbidityInteractions = new DataContainer(inpFile, 0, ComorbidityInteractionObject.class, this.loadDescriptions);
        this.dataMap.put(TableNames_EN.Comorbidity_Interactions, comorbidityInteractions);
        inpFile = this.rtBasePath + "/" + TableNames_EN.Diagnosis_Subchapters.getFileName();
        DataContainer diagnosisSubchapters = new DataContainer(inpFile, 0, DiagnosisSubchapterObject.class, this.loadDescriptions);
        this.dataMap.put(TableNames_EN.Diagnosis_Subchapters, diagnosisSubchapters);
        inpFile = this.rtBasePath + "/" + TableNames_EN.HIPPS_Structure.getFileName();
        DataContainer hippsValues = new DataContainer(inpFile, HippsValueObject.class, true);
        this.dataMap.put(TableNames_EN.HIPPS_Structure, hippsValues);
        inpFile = this.rtBasePath + "/" + TableNames_EN.OASIS_Responses.getFileName();
        DataContainer oasisResponces = new DataContainer(inpFile, OasisRespondObject.class, this.loadDescriptions);
        this.dataMap.put(TableNames_EN.OASIS_Responses, oasisResponces);
        inpFile = this.rtBasePath + "/" + TableNames_EN.Return_Codes.getFileName();
        DataContainer returnCodes = new DataContainer(inpFile, 0, ReturnCodeObject.class, true);
        this.dataMap.put(TableNames_EN.Return_Codes, returnCodes);
    }

    @Override
    public Map<TableNames_EN, DataContainerIF> getDataMap() {
        if (this.dataMap.get(TableNames_EN.Diagnoses) == null) {
            this.loadDxData();
        }
        return this.dataMap;
    }

    @Override
    public void setDataMap(Map<TableNames_EN, DataContainerIF> dataMap) {
        this.dataMap = dataMap;
    }
}

